/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.interop;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameUtil;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.BlockNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.nodes.FrameDescriptorProvider;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.objects.Dead;
import java.util.ArrayList;

@ExportLibrary(value=InteropLibrary.class)
final class ScopeMembers
implements TruffleObject {
    private final Frame frame;
    private final Node blockOrRoot;
    private Object[] members;

    ScopeMembers(Frame frame, Node blockOrRoot) {
        this.frame = frame;
        this.blockOrRoot = blockOrRoot;
    }

    @ExportMessage
    boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    Object readArrayElement(long index) throws InvalidArrayIndexException {
        Object[] allMembers = this.getAllMembers();
        if (0L <= index && index < (long)allMembers.length) {
            return allMembers[(int)index];
        }
        throw InvalidArrayIndexException.create((long)index);
    }

    @ExportMessage
    long getArraySize() {
        return this.getAllMembers().length;
    }

    @ExportMessage
    boolean isArrayElementReadable(long index) {
        return 0L <= index && index < (long)this.getAllMembers().length;
    }

    private Object[] getAllMembers() {
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (this.members == null ? 1 : 0) != 0)) {
            this.members = this.collectAllMembers();
        }
        return this.members;
    }

    /*
     * Unable to fully structure code
     */
    @CompilerDirectives.TruffleBoundary
    private Object[] collectAllMembers() {
        membersList = new ArrayList<Key>();
        if (this.frame == null) {
            descNode = this.blockOrRoot;
            while (descNode != null && descNode instanceof FrameDescriptorProvider) {
                desc = ((FrameDescriptorProvider)descNode).getFrameDescriptor();
                for (FrameSlot slot : desc.getSlots()) {
                    if (JSFrameUtil.isInternal(slot)) continue;
                    membersList.add(new Key(slot.getIdentifier().toString(), descNode, slot));
                }
                descNode = JavaScriptNode.findBlockScopeNode(descNode.getParent());
            }
        } else {
            descNode = this.blockOrRoot;
            outerFrame = this.frame;
            do {
                outerScope = outerFrame;
                while (true) {
                    for (FrameSlot slot : outerScope.getFrameDescriptor().getSlots()) {
                        if (JSFrameUtil.isInternal(slot) || ScopeMembers.isUnsetFrameSlot(outerScope, slot)) continue;
                        membersList.add(new Key(slot.getIdentifier().toString(), descNode, slot));
                    }
                    parentSlot = outerScope.getFrameDescriptor().findFrameSlot(ScopeFrameNode.PARENT_SCOPE_IDENTIFIER);
                    if (parentSlot == null) break;
                    outerScope = (Frame)FrameUtil.getObjectSafe((Frame)outerScope, (FrameSlot)parentSlot);
                    if (descNode == null) ** continue;
                    descNode = JavaScriptNode.findBlockScopeNode(descNode.getParent());
                }
                membersList.add(new Key("this", descNode, null));
            } while ((outerFrame = JSArguments.getEnclosingFrame(outerFrame.getArguments())) != JSFrameUtil.NULL_MATERIALIZED_FRAME);
        }
        return membersList.toArray();
    }

    static boolean isUnsetFrameSlot(Frame frame, FrameSlot slot) {
        Object value;
        return frame != null && frame.isObject(slot) && ((value = FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)slot)) == null || value == Dead.instance() || value instanceof Frame);
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class Key
    implements TruffleObject {
        private final String name;
        private final Node blockOrRoot;
        private final FrameSlot slot;
        private SourceSection sourceLocation;

        Key(String name, Node blockOrRoot, FrameSlot slot) {
            this.name = name;
            this.slot = slot;
            this.blockOrRoot = blockOrRoot;
        }

        @ExportMessage
        boolean isString() {
            return true;
        }

        @ExportMessage
        String asString() {
            return this.name;
        }

        public String toString() {
            return this.asString();
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean hasSourceLocation() {
            return this.getOrFindSourceLocation().isAvailable();
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        SourceSection getSourceLocation() throws UnsupportedMessageException {
            if (!this.hasSourceLocation()) {
                throw UnsupportedMessageException.create();
            }
            return this.sourceLocation;
        }

        private SourceSection getOrFindSourceLocation() {
            CompilerAsserts.neverPartOfCompilation();
            if (this.sourceLocation == null && this.blockOrRoot != null) {
                this.sourceLocation = this.findSourceLocation();
            }
            if (this.sourceLocation == null) {
                this.sourceLocation = JSBuiltin.createSourceSection();
            }
            return this.sourceLocation;
        }

        private SourceSection findSourceLocation() {
            if (this.slot != null) {
                class DeclarationFinder
                implements NodeVisitor {
                    JavaScriptNode found;

                    DeclarationFinder() {
                    }

                    public boolean visit(Node node) {
                        if (node instanceof JavaScriptNode) {
                            JSWriteFrameSlotNode write;
                            if (node instanceof JSWriteFrameSlotNode && (write = (JSWriteFrameSlotNode)node).getFrameSlot() == Key.this.slot && write.hasSourceSection()) {
                                this.found = write;
                                return false;
                            }
                            return true;
                        }
                        if (node == Key.this.blockOrRoot) {
                            return true;
                        }
                        return node instanceof BlockNode;
                    }
                }
                DeclarationFinder finder = new DeclarationFinder();
                this.blockOrRoot.accept((NodeVisitor)finder);
                if (finder.found != null) {
                    return finder.found.getSourceSection();
                }
            }
            return this.blockOrRoot.getEncapsulatingSourceSection();
        }
    }
}

