/**
 * DocumentTraversal contains methods that create iterators and tree-walkers to traverse a node and its children in document order (depth first, pre-order traversal, which is equivalent to the order in which the start tags occur in the text representation of the document). In DOMs which support the Traversal feature, DocumentTraversal will be implemented by the same objects that implement the Document interface.
 */
var DocumentTraversal = {
}
/**
 * Create a new NodeIterator over the subtree rooted at the specified node.
 * @syntax documentTraversal.createNodeIterator(root, whatToShow, filter, entityReferenceExpansion)
 * @param {Node} root The node which will be iterated together with its children. The iterator is initially positioned just before this node. The whatToShow flags and the filter, if any, are not considered when setting this position. The root must not be null.
 * @param {Number} whatToShow This flag specifies which node types may appear in the logical view of the tree presented by the iterator. See the description of NodeFilter for the set of possible SHOW_ values. These flags can be combined using OR.
 * @param {NodeFilter} filter The NodeFilter to be used with this TreeWalker, or null to indicate no filter.
 * @param {boolean} entityReferenceExpansion The value of this flag determines whether entity reference nodes are expanded.
 * @returns {NodeIterator} The newly created NodeIterator.
 */
DocumentTraversal.prototype.createNodeIterator = function(root,  whatToShow,  filter,  entityReferenceExpansion) {};

/**
 * Create a new TreeWalker over the subtree rooted at the specified node.
 * @syntax documentTraversal.createTreeWalker(root, whatToShow, filter, entityReferenceExpansion)
 * @param {Node} root The node which will serve as the root for the TreeWalker. The whatToShow flags and the NodeFilter are not considered when setting this value; any node type will be accepted as the root. The currentNode of the TreeWalker is initialized to this node, whether or not it is visible. The root functions as a stopping point for traversal methods that look upward in the document structure, such as parentNode and nextNode. The root must not be null.
 * @param {Number} whatToShow This flag specifies which node types may appear in the logical view of the tree presented by the tree-walker. See the description of NodeFilter for the set of possible SHOW_ values. These flags can be combined using OR.
 * @param {NodeFilter} filter The NodeFilter to be used with this TreeWalker, or null to indicate no filter.
 * @param {boolean} entityReferenceExpansion If this flag is false, the contents of EntityReference nodes are not presented in the logical view.
 * @returns {TreeWalker} The newly created TreeWalker.
 */
DocumentTraversal.prototype.createTreeWalker = function(root,  whatToShow,  filter,  entityReferenceExpansion) {};

/**
 * Represents the DocumentTraversal prototype object.
 * @syntax DocumentTraversal.prototype
 * @static
 */
DocumentTraversal.prototype;

