/**
 * A row in a table. See the TR element definition in HTML 4.01.
 */
var HTMLTableRowElement = {
}
/**
 * Background color for rows. See the bgcolor attribute definition in HTML 4.01. This attribute is deprecated in HTML 4.01.
 * @syntax hTMLTableRowElement.bgColor
 * @returns {String} 
 */
HTMLTableRowElement.prototype.bgColor = new String();

/**
 * Delete a cell from the current row.
 * @syntax hTMLTableRowElement.deleteCell(index)
 * @param {Number} index The index of the cell to delete, starting from 0. If the index is -1 the last cell in the row is deleted.
 * @returns {undefined} 
 */
HTMLTableRowElement.prototype.deleteCell = function(index) {};

/**
 * The collection of cells in this row.
 * @syntax hTMLTableRowElement.cells
 * @returns {HTMLCollection} 
 */
HTMLTableRowElement.prototype.cells = new HTMLCollection();

/**
 * The index of this row, relative to the current section (THEAD, TFOOT, or TBODY), starting from 0.
 * @syntax hTMLTableRowElement.sectionRowIndex
 * @returns {Number} 
 */
HTMLTableRowElement.prototype.sectionRowIndex = new Number();

/**
 * Offset of alignment character. See the charoff attribute definition in HTML 4.01.
 * @syntax hTMLTableRowElement.chOff
 * @returns {String} 
 */
HTMLTableRowElement.prototype.chOff = new String();

/**
 * Vertical alignment of data within cells of this row. See the valign attribute definition in HTML 4.01.
 * @syntax hTMLTableRowElement.vAlign
 * @returns {String} 
 */
HTMLTableRowElement.prototype.vAlign = new String();

/**
 * Insert an empty TD cell into this row. If index is -1 or equal to the number of cells, the new cell is appended.
 * @syntax hTMLTableRowElement.insertCell(index)
 * @param {Number} index The place to insert the cell, starting from 0.
 * @returns {HTMLElement} The newly created cell.
 */
HTMLTableRowElement.prototype.insertCell = function(index) {};

/**
 * Horizontal alignment of data within cells of this row. See the align attribute definition in HTML 4.01.
 * @syntax hTMLTableRowElement.align
 * @returns {String} 
 */
HTMLTableRowElement.prototype.align = new String();

/**
 * This is in logical order and not in document order. The rowIndex does take into account sections (THEAD, TFOOT, or TBODY) within the table, placing THEAD rows first in the index, followed by TBODY rows, followed by TFOOT rows.
 * @syntax hTMLTableRowElement.rowIndex
 * @returns {Number} 
 */
HTMLTableRowElement.prototype.rowIndex = new Number();

/**
 * Alignment character for cells in a column. See the char attribute definition in HTML 4.01.
 * @syntax hTMLTableRowElement.ch
 * @returns {String} 
 */
HTMLTableRowElement.prototype.ch = new String();

/**
 * Represents the HTMLTableRowElement prototype object.
 * @syntax HTMLTableRowElement.prototype
 * @static
 */
HTMLTableRowElement.prototype;

