/**
 */
var document = new HTMLDocument();
/**
 * @returns {undefined}
 * @static
 */
document.registerContentHandler = function() {};

/**
 * @returns {String}
 * @static
 */
document.designMode = new String();

/**
 * @syntax var xpathResult = document.evaluate(xpathExpression, contextNode, namespaceResolver, resultType, result);
 * @param {String} xpathExpression
 * @param {Node} contextNode
 * @param {String} namespaceResolver
 * @param {Number} resultType
 * @param {XPathResult} result
 * @returns {XPathResult}
 * @static
 */
document.evaluate = function(xpathExpression,  contextNode,  namespaceResolver,  resultType,  result) {};

/**
 * @returns {Location}
 * @static
 */
document.location = new Location();

/**
 * @returns {HTMLCollection}
 * @static
 */
document.plugins = new HTMLCollection();

/**
 * @syntax target.addEventListener(type, listener[, useCapture]);<br>target.addEventListener(type, listener[, useCapture, aWantsUntrusted); // Gecko/Mozilla only
 * @param {String} type
 * @param {Function} listener
 * @returns {Boolean}
 * @static
 */
document.addEventListener = function(type,  listener) {};

/**
 * @returns {String}
 * @static
 */
document.compatMode = new String();

/**
 * @syntax nsResolver = document.createNSResolver(node);
 * @param {Node} node
 * @returns {XPathNSResolver}
 * @static
 */
document.createNSResolver = function(node) {};

/**
 * @returns {Node}
 * @static
 */
document.tooltipNode = new Node();

/**
 * @returns {NodeList}
 * @static
 */
document.querySelectorAll = function() {};

/**
 * @returns {HTMLCollection}
 * @static
 */
document.embeds = new HTMLCollection();

/**
 * @returns {String}
 * @static
 */
document.contentType = new String();

/**
 * @syntax focused = document.hasFocus();
 * @returns {Boolean}
 * @static
 */
document.hasFocus = function() {};

/**
 * @returns {Window}
 * @static
 */
document.defaultView = new Window();

/**
 * @returns {Node}
 * @static
 */
document.popupNode = new Node();

/**
 * @returns {HTMLCollection}
 * @static
 */
document.scripts = new HTMLCollection();

/**
 * @syntax elements = document.getElementsByClassName(names);<br>elements = rootElement.getElementsByClassName(names); 
 * @param {String} names
 * @returns {NodeList}
 * @static
 */
document.getElementsByClassName = function(names) {};

/**
 * @returns {Element}
 * @static
 */
document.querySelector = function() {};

/**
 * @returns {String}
 * @static
 */
document.dir = new String();

/**
 * @syntax var isEnabled = document.queryCommandEnabled(command);
 * @param {String} command
 * @returns {Boolean}
 * @static
 */
document.queryCommandEnabled = function(command) {};

/**
 * @syntax document.execCommand(aCommandName, aShowDefaultUI, aValueArgument)
 * @param {String} aCommandName
 * @param {Boolean} aShowDefaultUI
 * @param {String} aValueArgument
 * @returns {undefined}
 * @static
 */
document.execCommand = function(aCommandName,  aShowDefaultUI,  aValueArgument) {};

/**
 * @returns {Element}
 * @static
 */
document.activeElement = new Element();

/**
 * @returns {HTMLHeadElement}
 * @static
 */
document.head = new HTMLHeadElement();

/**
 * @returns {undefined}
 * @static
 */
document.releaseCapture = function() {};

/**
 * @returns {String}
 * @static
 */
document.lastModified = new String();

/**
 * @returns {String}
 * @static
 */
document.characterSet = new String();

/**
 * @syntax xpathExpr = document.createExpression(xpathText, namespaceURLMapper);
 * @param {String} xpathText
 * @param {Function} namespaceURLMapper
 * @returns {String}
 * @static
 */
document.createExpression = function(xpathText,  namespaceURLMapper) {};

/**
 * @returns {String}
 * @static
 */
document.readyState = new String();

/**
 * @syntax var element = document.elementFromPoint(x, y);
 * @param {Number} x
 * @param {Number} y
 * @returns {Element}
 * @static
 */
document.elementFromPoint = function(x,  y) {};

/**
 * @returns {undefined}
 * @static
 */
document.registerProtocolHandler = function() {};

/**
 * @syntax var isState = document.queryCommandState(command);
 * @param {String} command
 * @returns {Boolean}
 * @static
 */
document.queryCommandState = function(command) {};

/**
 * @syntax var isIndeterm = document.queryCommandIndeterm(command);
 * @param {String} command
 * @returns {Boolean}
 * @static
 */
document.queryCommandIndeterm = function(command) {};

/**
 * @returns {undefined}
 * @static
 */
document.async;

/**
 * @syntax range = document.createRange();
 * @returns {Range}
 * @static
 */
document.createRange = function() {};

/**
 * @syntax var event = document.createEvent(type);
 * @param {String} type
 * @returns {Event}
 * @static
 */
document.createEvent = function(type) {};

/**
 * @syntax var isValue = document.queryCommandValue(command);
 * @param {String} command
 * @returns {Boolean}
 * @static
 */
document.queryCommandValue = function(command) {};

/**
 * @syntax var isSupported = document.queryCommandSupported(command);
 * @param {String} command
 * @returns {Boolean}
 * @static
 */
document.queryCommandSupported = function(command) {};

/**
 * @returns {Selection}
 * @static
 */
document.getSelection = function() {};

/**
 * @returns {undefined}
 * @static
 */
document.load = function() {};

/**
 * @returns {StyleSheetList}
 * @static
 */
document.styleSheets = new StyleSheetList();

/**
 * @syntax var treeWalker = document.createTreeWalker(root, whatToShow, filter, entityReferenceExpansion);
 * @param {Node} root
 * @param {Number} whatToShow
 * @param {Number} filter
 * @param {String} entityReferenceExpansion
 * @returns {TreeWalker}
 * @static
 */
document.createTreeWalker = function(root,  whatToShow,  filter,  entityReferenceExpansion) {};

/**
 * Represents the document prototype object.
 * @syntax document.prototype
 * @static
 */
document.prototype;

