/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.effects;

import ddf.minim.AudioEffect;
import processing.core.PApplet;

public abstract class IIRFilter
implements AudioEffect {
    protected float[] a;
    protected float[] b;
    private float[] inLeft;
    private float[] outLeft;
    private float[] inRight;
    private float[] outRight;
    private float freq;
    private float srate;

    public IIRFilter(float freq, float sampleRate) {
        this.srate = sampleRate;
        this.setFreq(freq);
        this.initArrays();
    }

    final void initArrays() {
        int memSize = this.a.length >= this.b.length ? this.a.length : this.b.length;
        this.inLeft = new float[memSize];
        this.outLeft = new float[memSize];
        this.inRight = new float[memSize];
        this.outRight = new float[memSize];
    }

    public final synchronized void process(float[] signal) {
        int i = 0;
        while (i < signal.length) {
            System.arraycopy(this.inLeft, 0, this.inLeft, 1, this.inLeft.length - 1);
            this.inLeft[0] = signal[i];
            float y = 0.0f;
            int j = 0;
            while (j < this.a.length) {
                y += this.a[j] * this.inLeft[j];
                ++j;
            }
            j = 0;
            while (j < this.b.length) {
                y += this.b[j] * this.outLeft[j];
                ++j;
            }
            System.arraycopy(this.outLeft, 0, this.outLeft, 1, this.outLeft.length - 1);
            this.outLeft[0] = y;
            signal[i] = y;
            ++i;
        }
    }

    public final synchronized void process(float[] sigLeft, float[] sigRight) {
        int i = 0;
        while (i < sigLeft.length) {
            System.arraycopy(this.inLeft, 0, this.inLeft, 1, this.inLeft.length - 1);
            this.inLeft[0] = sigLeft[i];
            System.arraycopy(this.inRight, 0, this.inRight, 1, this.inRight.length - 1);
            this.inRight[0] = sigRight[i];
            float yL = 0.0f;
            float yR = 0.0f;
            int j = 0;
            while (j < this.a.length) {
                yL += this.a[j] * this.inLeft[j];
                yR += this.a[j] * this.inRight[j];
                ++j;
            }
            j = 0;
            while (j < this.b.length) {
                yL += this.b[j] * this.outLeft[j];
                yR += this.b[j] * this.outRight[j];
                ++j;
            }
            System.arraycopy(this.outLeft, 0, this.outLeft, 1, this.outLeft.length - 1);
            this.outLeft[0] = yL;
            sigLeft[i] = yL;
            System.arraycopy(this.outRight, 0, this.outRight, 1, this.outRight.length - 1);
            this.outRight[0] = yR;
            sigRight[i] = yR;
            ++i;
        }
    }

    public final void setFreq(float f) {
        if (this.validFreq(f)) {
            this.freq = f;
            this.calcCoeff();
        }
    }

    public boolean validFreq(float f) {
        return f > 0.0f;
    }

    public final float frequency() {
        return this.freq;
    }

    public final float sampleRate() {
        return this.srate;
    }

    protected abstract void calcCoeff();

    public final void printCoeff() {
        PApplet.println((String)"Filter coefficients: ");
        int i = 0;
        while (i < this.a.length) {
            PApplet.print((String)("  A" + i + ": " + this.a[i]));
            ++i;
        }
        PApplet.println();
        i = 0;
        while (i < this.b.length) {
            PApplet.print((String)("  B" + (i + 1) + ": " + this.b[i]));
            ++i;
        }
        PApplet.println();
    }
}

