/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.hslf.record.ParentAwareRecord;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.util.MutableByteArrayOutputStream;
import org.apache.poi.util.ArrayUtil;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.Removal;

public abstract class RecordContainer
extends Record {
    protected Record[] _children;

    @Override
    public Record[] getChildRecords() {
        return this._children;
    }

    @Override
    public boolean isAnAtom() {
        return false;
    }

    private int findChildLocation(Record child) {
        int i = 0;
        for (Record r : this._children) {
            if (r.equals(child)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int appendChild(Record newChild) {
        Record[] nc = new Record[this._children.length + 1];
        System.arraycopy(this._children, 0, nc, 0, this._children.length);
        nc[this._children.length] = newChild;
        this._children = nc;
        return this._children.length;
    }

    private void addChildAt(Record newChild, int position) {
        this.appendChild(newChild);
        this.moveChildRecords(this._children.length - 1, position, 1);
    }

    private void moveChildRecords(int oldLoc, int newLoc, int number) {
        if (oldLoc == newLoc) {
            return;
        }
        if (number == 0) {
            return;
        }
        if (oldLoc + number > this._children.length) {
            throw new IllegalArgumentException("Asked to move more records than there are!");
        }
        ArrayUtil.arrayMoveWithin((Object[])this._children, (int)oldLoc, (int)newLoc, (int)number);
    }

    public Record findFirstOfType(long type) {
        for (Record r : this._children) {
            if (r.getRecordType() != type) continue;
            return r;
        }
        return null;
    }

    public Record removeChild(Record ch) {
        Record rm = null;
        ArrayList<Record> lst = new ArrayList<Record>();
        for (Record r : this._children) {
            if (r != ch) {
                lst.add(r);
                continue;
            }
            rm = r;
        }
        this._children = lst.toArray(new Record[0]);
        return rm;
    }

    public int appendChildRecord(Record newChild) {
        return this.appendChild(newChild);
    }

    public int addChildAfter(Record newChild, Record after) {
        int loc = this.findChildLocation(after);
        if (loc == -1) {
            throw new IllegalArgumentException("Asked to add a new child after another record, but that record wasn't one of our children!");
        }
        this.addChildAt(newChild, loc + 1);
        return loc + 1;
    }

    public int addChildBefore(Record newChild, Record before) {
        int loc = this.findChildLocation(before);
        if (loc == -1) {
            throw new IllegalArgumentException("Asked to add a new child before another record, but that record wasn't one of our children!");
        }
        this.addChildAt(newChild, loc);
        return loc;
    }

    @Removal(version="3.19")
    @Deprecated
    public void moveChildBefore(Record child, Record before) {
        this.moveChildrenBefore(child, 1, before);
    }

    @Removal(version="3.19")
    @Deprecated
    public void moveChildrenBefore(Record firstChild, int number, Record before) {
        if (number < 1) {
            return;
        }
        int newLoc = this.findChildLocation(before);
        if (newLoc == -1) {
            throw new IllegalArgumentException("Asked to move children before another record, but that record wasn't one of our children!");
        }
        int oldLoc = this.findChildLocation(firstChild);
        if (oldLoc == -1) {
            throw new IllegalArgumentException("Asked to move a record that wasn't a child!");
        }
        this.moveChildRecords(oldLoc, newLoc, number);
    }

    @Removal(version="3.19")
    @Deprecated
    public void moveChildrenAfter(Record firstChild, int number, Record after) {
        if (number < 1) {
            return;
        }
        int newLoc = this.findChildLocation(after);
        if (newLoc == -1) {
            throw new IllegalArgumentException("Asked to move children before another record, but that record wasn't one of our children!");
        }
        ++newLoc;
        int oldLoc = this.findChildLocation(firstChild);
        if (oldLoc == -1) {
            throw new IllegalArgumentException("Asked to move a record that wasn't a child!");
        }
        this.moveChildRecords(oldLoc, newLoc, number);
    }

    public void setChildRecord(Record[] records) {
        this._children = (Record[])records.clone();
    }

    public void writeOut(byte headerA, byte headerB, long type, Record[] children, OutputStream out) throws IOException {
        if (out instanceof MutableByteArrayOutputStream) {
            MutableByteArrayOutputStream mout = (MutableByteArrayOutputStream)out;
            int oldSize = mout.getBytesWritten();
            mout.write(new byte[]{headerA, headerB});
            byte[] typeB = new byte[2];
            LittleEndian.putShort((byte[])typeB, (int)0, (short)((short)type));
            mout.write(typeB);
            mout.write(new byte[4]);
            for (Record aChildren : children) {
                aChildren.writeOut(mout);
            }
            int length = mout.getBytesWritten() - oldSize - 8;
            byte[] size = new byte[4];
            LittleEndian.putInt((byte[])size, (int)0, (int)length);
            mout.overwrite(size, oldSize + 4);
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(new byte[]{headerA, headerB});
            byte[] typeB = new byte[2];
            LittleEndian.putShort((byte[])typeB, (int)0, (short)((short)type));
            baos.write(typeB);
            baos.write(new byte[]{0, 0, 0, 0});
            for (Record aChildren : children) {
                aChildren.writeOut(baos);
            }
            byte[] toWrite = baos.toByteArray();
            LittleEndian.putInt((byte[])toWrite, (int)4, (int)(toWrite.length - 8));
            out.write(toWrite);
        }
    }

    public static void handleParentAwareRecords(RecordContainer br) {
        for (Record record : br.getChildRecords()) {
            if (record instanceof ParentAwareRecord) {
                ((ParentAwareRecord)((Object)record)).setParentRecord(br);
            }
            if (!(record instanceof RecordContainer)) continue;
            RecordContainer.handleParentAwareRecords((RecordContainer)record);
        }
    }

    public Map<String, Supplier<?>> getGenericProperties() {
        return null;
    }
}

