/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.autoupdate.services.AutoupdateSettings;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateManagerImpl;
import org.netbeans.modules.autoupdate.updateprovider.AutoupdateCatalogFactory;
import org.netbeans.modules.autoupdate.updateprovider.AutoupdateCatalogProvider;
import org.netbeans.modules.autoupdate.updateprovider.LocalNBMsProvider;
import org.netbeans.spi.autoupdate.UpdateProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UpdateUnitProviderImpl {
    private UpdateProvider provider;
    private static Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.services.UpdateUnitProviderImpl");
    private static final String REMOVED_MASK = "_removed";
    private static final String URL = "url";
    private static final String DISPLAY_NAME = "displayName";
    private static final String ENABLED = "enabled";
    private static final String CATEGORY_NAME = "categoryName";
    private static final LookupListenerImpl UPDATE_PROVIDERS = new LookupListenerImpl();

    public UpdateUnitProviderImpl(UpdateProvider updateProvider) {
        this.provider = updateProvider;
    }

    public String getName() {
        return this.getUpdateProvider().getName();
    }

    public String getDescription() {
        return this.getUpdateProvider().getDescription();
    }

    public UpdateUnitProvider.CATEGORY getCategory() {
        return this.getUpdateProvider().getCategory();
    }

    public String getDisplayName() {
        return UpdateUnitProviderImpl.loadDisplayName(this.getUpdateProvider());
    }

    public void setDisplayName(String string) {
        UpdateUnitProviderImpl.storeDisplayName(this.getUpdateProvider(), string);
    }

    public URL getProviderURL() {
        return UpdateUnitProviderImpl.loadUrl(this.getUpdateProvider());
    }

    public void setProviderURL(URL uRL) {
        UpdateUnitProviderImpl.storeUrl(this.getUpdateProvider(), uRL);
    }

    public List<UpdateUnit> getUpdateUnits(UpdateManager.TYPE ... tYPEArray) {
        return UpdateManagerImpl.getUpdateUnits(this.getUpdateProvider(), tYPEArray);
    }

    public boolean refresh(ProgressHandle progressHandle, boolean bl) throws IOException {
        boolean bl2 = false;
        if (progressHandle != null) {
            progressHandle.progress(NbBundle.getMessage(UpdateUnitProviderImpl.class, (String)"UpdateUnitProviderImpl_FormatCheckingForUpdates", (Object)this.getDisplayName()));
        }
        UpdateProvider updateProvider = this.getUpdateProvider();
        updateProvider.refresh(bl);
        if (bl) {
            AutoupdateSettings.setLastCheck(new Date());
            AutoupdateSettings.setLastCheck(updateProvider.getName(), new Date());
        }
        UpdateManagerImpl.getInstance().clearCache();
        return bl2;
    }

    public void setEnable(boolean bl) {
        UpdateManagerImpl.getInstance().clearCache();
        UpdateUnitProviderImpl.storeState(this.getUpdateProvider(), bl);
    }

    public boolean isEnabled() {
        return UpdateUnitProviderImpl.loadState(this.getUpdateProvider().getName());
    }

    public UpdateProvider getUpdateProvider() {
        assert (this.provider != null) : "UpdateProvider found.";
        return this.provider;
    }

    public static void remove(UpdateUnitProvider updateUnitProvider) {
        UpdateUnitProviderImpl updateUnitProviderImpl = Trampoline.API.impl(updateUnitProvider);
        updateUnitProviderImpl.remove();
    }

    private void remove() {
        try {
            if (UpdateUnitProviderImpl.getPreferences().nodeExists(this.getName())) {
                UpdateUnitProviderImpl.getPreferences().node(this.getName()).removeNode();
                UpdateUnitProviderImpl.getPreferences().node(this.getName() + REMOVED_MASK).putBoolean(REMOVED_MASK, true);
            } else {
                UpdateUnitProviderImpl.getPreferences().node(this.getName() + REMOVED_MASK).putBoolean(REMOVED_MASK, true);
            }
        }
        catch (BackingStoreException backingStoreException) {
            Exceptions.printStackTrace((Throwable)backingStoreException);
        }
        UpdateManagerImpl.getInstance().clearCache();
    }

    public static UpdateUnitProvider createUpdateUnitProvider(String string, String string2, URL uRL) {
        return UpdateUnitProviderImpl.createUpdateUnitProvider(string, string2, uRL, UpdateUnitProvider.CATEGORY.COMMUNITY);
    }

    public static UpdateUnitProvider createUpdateUnitProvider(String string, String string2, URL uRL, UpdateUnitProvider.CATEGORY cATEGORY) {
        string = UpdateUnitProviderImpl.normalizeCodeName(string);
        UpdateUnitProviderImpl.storeProvider(string, string2, uRL);
        AutoupdateCatalogProvider autoupdateCatalogProvider = new AutoupdateCatalogProvider(string, string2, uRL, cATEGORY);
        return Trampoline.API.createUpdateUnitProvider(new UpdateUnitProviderImpl(autoupdateCatalogProvider));
    }

    public static UpdateUnitProvider createUpdateUnitProvider(String string, File ... fileArray) {
        string = UpdateUnitProviderImpl.normalizeCodeName(string);
        LocalNBMsProvider localNBMsProvider = new LocalNBMsProvider(string, fileArray);
        return Trampoline.API.createUpdateUnitProvider(new UpdateUnitProviderImpl(localNBMsProvider));
    }

    public static List<UpdateUnitProvider> getUpdateUnitProviders(boolean bl) {
        Object object;
        Object object2;
        ArrayList<UpdateUnitProvider> arrayList;
        Object object3;
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Services/AutoupdateType");
        if (fileObject != null) {
            object3 = fileObject.getChildren();
            for (int i = 0; i < ((FileObject[])object3).length; ++i) {
                try {
                    if (UpdateUnitProviderImpl.getPreferences().nodeExists(object3[i].getName())) continue;
                    try {
                        arrayList = (String)object3[i].getAttribute("SystemFileSystem.localizingBundle");
                        if (arrayList != null) {
                            object2 = AutoupdateCatalogFactory.createUpdateProvider((FileObject)object3[i]);
                            assert (object2 != null) : "UpdateProvider found for " + object3[i];
                            UpdateUnitProviderImpl.getPreferences().node(object3[i].getName()).putBoolean("loaded", Boolean.TRUE);
                            err.log(Level.FINEST, object3[i] + " loaded.");
                            continue;
                        }
                        err.log(Level.INFO, object3[i] + " cannot be loaded because doesn't contain SystemFileSystem.localizingBundle.");
                        UpdateUnitProviderImpl.getPreferences().node(object3[i].getName()).putBoolean("loaded", Boolean.FALSE);
                    }
                    catch (Exception exception) {
                        Exceptions.printStackTrace((Throwable)exception);
                    }
                    continue;
                }
                catch (BackingStoreException backingStoreException) {
                    err.log(Level.INFO, backingStoreException.getMessage() + " while loading " + object3[i], backingStoreException);
                }
            }
        }
        object3 = UPDATE_PROVIDERS.allInstances();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        arrayList = object3.iterator();
        while (arrayList.hasNext()) {
            object2 = (String[])arrayList.next();
            try {
                if (UpdateUnitProviderImpl.getPreferences().nodeExists(object2.getName() + REMOVED_MASK)) {
                    continue;
                }
            }
            catch (BackingStoreException backingStoreException) {
                Exceptions.printStackTrace((Throwable)backingStoreException);
            }
            hashMap.put(object2.getName(), object2);
        }
        try {
            arrayList = UpdateUnitProviderImpl.getPreferences();
            object2 = ((Preferences)((Object)arrayList)).childrenNames();
            if (object2 != null) {
                for (int i = 0; i < ((String[])object2).length; ++i) {
                    object = UpdateUnitProviderImpl.loadProvider(object2[i]);
                    if (object != null && hashMap.containsKey(object.getName())) {
                        err.log(Level.FINE, "Customized Provider " + object.getName());
                    }
                    if (object != null) {
                        hashMap.put(object.getName(), object);
                    }
                    boolean bl2 = UpdateUnitProviderImpl.loadState((String)object2[i]);
                    if (!bl || bl2) continue;
                    hashMap.remove(object2[i]);
                }
            }
        }
        catch (BackingStoreException backingStoreException) {
            err.log(Level.INFO, backingStoreException.getMessage(), backingStoreException);
        }
        arrayList = new ArrayList<UpdateUnitProvider>(hashMap.values().size());
        for (UpdateProvider updateProvider : hashMap.values()) {
            object = new UpdateUnitProviderImpl(updateProvider);
            arrayList.add(Trampoline.API.createUpdateUnitProvider((UpdateUnitProviderImpl)object));
        }
        return arrayList;
    }

    public static void refreshProviders(ProgressHandle progressHandle, boolean bl) throws IOException {
        List<UpdateUnitProvider> list = UpdateUnitProviderImpl.getUpdateUnitProviders(true);
        for (UpdateUnitProvider updateUnitProvider : list) {
            updateUnitProvider.refresh(progressHandle, bl);
            AutoupdateSettings.setLastCheck(updateUnitProvider.getName(), new Date());
        }
        if (bl) {
            AutoupdateSettings.setLastCheck(new Date());
        }
        UpdateManagerImpl.getInstance().clearCache();
    }

    private static void storeProvider(String string, String string2, URL uRL) {
        if (string.contains("/")) {
            string = string.replaceAll("/", "_");
        }
        Preferences preferences = UpdateUnitProviderImpl.getPreferences().node(string);
        assert (preferences != null) : "Preferences node " + string + " found.";
        preferences.put(URL, uRL.toString());
        preferences.put(DISPLAY_NAME, string2);
    }

    private static Preferences getPreferences() {
        return NbPreferences.root().node("/org/netbeans/modules/autoupdate");
    }

    static UpdateProvider loadProvider(String string) {
        URL uRL;
        UpdateUnitProvider.CATEGORY cATEGORY;
        String string2;
        block4: {
            Preferences preferences = UpdateUnitProviderImpl.getPreferences().node(string);
            assert (preferences != null) : "Preferences node " + string + " found.";
            String string3 = preferences.get(URL, preferences.get("originalUrl", null));
            string2 = preferences.get(DISPLAY_NAME, preferences.get("originalDisplayName", string));
            cATEGORY = UpdateUnitProvider.CATEGORY.valueOf(preferences.get(CATEGORY_NAME, preferences.get("originalCategoryName", UpdateUnitProvider.CATEGORY.COMMUNITY.name())));
            if (string3 == null) {
                return null;
            }
            uRL = null;
            try {
                uRL = new URL(string3);
            }
            catch (MalformedURLException malformedURLException) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)malformedURLException);
            }
        }
        return new AutoupdateCatalogProvider(string, string2, uRL, cATEGORY);
    }

    private static boolean loadState(String string) {
        Preferences preferences = UpdateUnitProviderImpl.getPreferences().node(string);
        assert (preferences != null) : "Preferences node " + string + " found.";
        String string2 = preferences.get(ENABLED, preferences.get("originalEnabled", null));
        return !Boolean.FALSE.toString().equals(string2);
    }

    private static void storeState(UpdateProvider updateProvider, boolean bl) {
        Preferences preferences = UpdateUnitProviderImpl.getPreferences().node(updateProvider.getName());
        assert (preferences != null) : "Preferences node " + updateProvider.getName() + " found.";
        preferences.put(ENABLED, Boolean.valueOf(bl).toString());
    }

    private static String loadDisplayName(UpdateProvider updateProvider) {
        Preferences preferences = UpdateUnitProviderImpl.getPreferences().node(updateProvider.getName());
        assert (preferences != null) : "Preferences node " + updateProvider.getName() + " found.";
        return preferences.get(DISPLAY_NAME, updateProvider.getDisplayName());
    }

    private static void storeDisplayName(UpdateProvider updateProvider, String string) {
        Preferences preferences = UpdateUnitProviderImpl.getPreferences().node(updateProvider.getName());
        assert (preferences != null) : "Preferences node " + updateProvider.getName() + " found.";
        if (string == null) {
            preferences.remove(DISPLAY_NAME);
        } else if (!string.equals(updateProvider.getDisplayName())) {
            preferences.put(DISPLAY_NAME, string);
        }
    }

    private static URL loadUrl(UpdateProvider updateProvider) {
        Preferences preferences = UpdateUnitProviderImpl.getPreferences().node(updateProvider.getName());
        assert (preferences != null) : "Preferences node " + updateProvider.getName() + " found.";
        String string = null;
        if (updateProvider instanceof AutoupdateCatalogProvider) {
            string = ((AutoupdateCatalogProvider)updateProvider).getUpdateCenterURL().toExternalForm();
        }
        if ((string = preferences.get(URL, string)) == null || string.length() == 0) {
            return null;
        }
        int n = string.indexOf("?unique");
        if (n != -1) {
            string = string.substring(0, n);
        }
        err.log(Level.FINE, "Use urlSpec " + string + " for Provider " + updateProvider);
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            err.log(Level.INFO, malformedURLException.getMessage(), malformedURLException);
        }
        return uRL;
    }

    private static void storeUrl(UpdateProvider updateProvider, URL uRL) {
        Preferences preferences = UpdateUnitProviderImpl.getPreferences().node(updateProvider.getName());
        assert (preferences != null) : "Preferences node " + updateProvider.getName() + " found.";
        if (uRL == null) {
            preferences.remove(URL);
        } else {
            URL uRL2 = null;
            if (updateProvider instanceof AutoupdateCatalogProvider) {
                uRL2 = ((AutoupdateCatalogProvider)updateProvider).getUpdateCenterURL();
            }
            if (!uRL.toExternalForm().equals(uRL2.toExternalForm())) {
                preferences.put(URL, uRL.toExternalForm());
                if (updateProvider instanceof AutoupdateCatalogProvider) {
                    ((AutoupdateCatalogProvider)updateProvider).setUpdateCenterURL(uRL);
                }
            }
        }
    }

    private static String normalizeCodeName(String string) {
        List<Character> list = Arrays.asList(Character.valueOf('\"'), Character.valueOf('*'), Character.valueOf('/'), Character.valueOf(':'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('?'), Character.valueOf('\\'), Character.valueOf('|'));
        StringBuffer stringBuffer = new StringBuffer();
        for (char c : string.toCharArray()) {
            if (list.contains(Character.valueOf(c))) {
                c = '_';
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LookupListenerImpl
    implements LookupListener {
        final Lookup.Result<UpdateProvider> result = Lookup.getDefault().lookupResult(UpdateProvider.class);

        public LookupListenerImpl() {
            this.result.addLookupListener((LookupListener)this);
        }

        public void resultChanged(LookupEvent lookupEvent) {
            err.log(Level.FINE, "Lookup.Result changed " + lookupEvent);
            try {
                UpdateUnitProviderImpl.refreshProviders(null, false);
            }
            catch (IOException iOException) {
                err.log(Level.INFO, iOException.getMessage(), iOException);
            }
        }

        public Collection<? extends UpdateProvider> allInstances() {
            Collection collection = this.result.allInstances();
            return collection;
        }
    }
}

