/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.tr.l10n;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    private static final Logger log = Logger.getLogger(Config.class.getName());
    private static final String CONFIG_FILENAME = "tr.conf";
    private static final String OPTION_KEY_LOCALE = "--locale";
    private static Config instance;
    private String location;

    public static Config getDefault() {
        if (instance == null) {
            instance = new Config();
        }
        return instance;
    }

    private Config() {
        this.initLocation();
    }

    private int defaultOptionIndex(String key) {
        if (!this.existsConfigFile()) {
            return -1;
        }
        log.info("Key: " + key);
        if (key == null) {
            return -1;
        }
        int index = 0;
        for (String option : this.defaultOptionsRead()) {
            log.info("Option: " + option);
            if (option.startsWith(key)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private String getLocaleValue(String langCode, String countryCode) {
        if (langCode == null || langCode.length() != 2) {
            return null;
        }
        if (countryCode == null || countryCode.length() != 2) {
            return langCode;
        }
        return langCode + ":" + countryCode;
    }

    public void setLocale(String langCode, String countryCode) {
        if (!this.existsConfigFile()) {
            return;
        }
        String localeValue = this.getLocaleValue(langCode, countryCode);
        if (localeValue == null) {
            log.info("Locale: null");
            return;
        }
        String locale = "--locale " + localeValue;
        int index = this.defaultOptionIndex(OPTION_KEY_LOCALE);
        if (index == -1) {
            log.info("Adding locale: " + locale);
            this.defaultOptionAdd(locale);
        } else {
            log.info("Replacing locale to: " + locale);
            this.defaultOptionReplace(index, "--locale " + localeValue);
        }
    }

    public void removeLocale() {
        if (!this.existsConfigFile()) {
            return;
        }
        int index = this.defaultOptionIndex(OPTION_KEY_LOCALE);
        if (index == -1) {
            log.info("No locale option to remove.");
            return;
        }
        log.info("Removing locale option.");
        this.defaultOptionRemove(index);
    }

    public void defaultOptionAdd(String option) {
        if (!this.existsConfigFile()) {
            return;
        }
        List<String> options = this.defaultOptionsRead();
        options.add(option);
        this.defaultOptionsWrite(options);
    }

    public void defaultOptionReplace(int index, String newValue) {
        if (!this.existsConfigFile()) {
            return;
        }
        List<String> options = this.defaultOptionsRead();
        if (index >= options.size()) {
            return;
        }
        options.set(index, newValue);
        this.defaultOptionsWrite(options);
    }

    public void defaultOptionRemove(int index) {
        if (!this.existsConfigFile()) {
            return;
        }
        List<String> options = this.defaultOptionsRead();
        if (index >= options.size()) {
            return;
        }
        options.remove(index);
        this.defaultOptionsWrite(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backupConfigFile() {
        if (!this.existsConfigFile()) {
            return;
        }
        InputStream inFile = null;
        OutputStream outFile = null;
        try {
            inFile = new FileInputStream(this.location);
            outFile = new FileOutputStream(this.location + ".backup");
            FileUtil.copy((InputStream)inFile, (OutputStream)outFile);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            try {
                inFile.close();
                outFile.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public boolean isConfigFileBackedUp() {
        File backup = new File(this.location + ".backup");
        return backup.exists();
    }

    public File getBackupFile() {
        File backup = new File(this.location + ".backup");
        if (backup.exists()) {
            return backup;
        }
        log.warning("Missing config backup file: " + backup.getPath());
        return null;
    }

    public File getConfigFile() {
        File file = new File(this.location);
        if (file.isFile()) {
            return file;
        }
        log.severe("Missing configuration file: " + this.location);
        return null;
    }

    private boolean existsConfigFile() {
        return this.getConfigFile() != null;
    }

    public String getLocation() {
        return this.location;
    }

    public List<String> defaultOptionsRead() {
        if (!this.existsConfigFile()) {
            return Collections.emptyList();
        }
        String[] allOptions = this.getParameters().getProperty("default_options").split("\\s");
        int last = allOptions.length - 1;
        allOptions[0] = allOptions[0].substring(1, allOptions[0].length());
        allOptions[last] = allOptions[last].substring(0, allOptions[last].length() - 1);
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < allOptions.length; ++i) {
            String item = allOptions[i];
            if (item.length() < 2) continue;
            String beginning = item.substring(0, 2);
            if (beginning.equals("-J")) {
                ret.add(item);
                continue;
            }
            if (!beginning.equals("--")) continue;
            if (item.startsWith("--laf")) {
                ret.add(item + " " + allOptions[i + 1]);
                continue;
            }
            if (item.startsWith("--fontsize")) {
                ret.add(item + " " + allOptions[i + 1]);
                continue;
            }
            if (!item.startsWith(OPTION_KEY_LOCALE)) continue;
            ret.add(item + " " + allOptions[i + 1]);
        }
        return ret;
    }

    public String getJDKHome() {
        if (!this.existsConfigFile()) {
            return null;
        }
        String prop = this.getParameters().getProperty("netbeans_jdkhome");
        if (prop == null) {
            return null;
        }
        return prop.substring(1, prop.length() - 1);
    }

    public Properties getParameters() {
        if (!this.existsConfigFile()) {
            return new Properties();
        }
        Properties props = new Properties();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(this.getConfigFile()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line == null || line.equals("") || line.charAt(0) == '#') continue;
                String key = line.substring(0, line.indexOf(61));
                String value = line.substring(line.indexOf(61) + 1, line.length());
                props.setProperty(key, value);
            }
        }
        catch (IOException ioe) {
            log.log(Level.SEVERE, "Could not read config file.", ioe);
        }
        return props;
    }

    public void setJDKHome(String jdkHome) {
        if (this.getConfigFile() == null) {
            return;
        }
        Properties paras = this.getParameters();
        paras.setProperty("netbeans_jdkhome", "\"" + jdkHome + "\"");
        this.setParameters(paras);
    }

    private void defaultOptionsWrite(List<String> options) {
        Properties props = this.getParameters();
        String optionsStr = "";
        for (String option : options) {
            optionsStr = optionsStr + option + " ";
        }
        optionsStr = optionsStr.trim();
        props.setProperty("default_options", "\"" + optionsStr + "\"");
        this.setParameters(props);
    }

    private void setParameters(Properties paras) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.location));
            writer.write("### ThinkingRock Configuration File ###");
            writer.newLine();
            Enumeration<?> keys = paras.propertyNames();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement().toString();
                String value = paras.getProperty(key);
                writer.write(key + "=" + value);
                writer.newLine();
            }
            writer.close();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void initLocation() {
        this.location = System.getProperty("netbeans.home");
        this.location = this.location.substring(0, this.location.lastIndexOf(File.separator));
        this.location = this.location + File.separator + "etc" + File.separator + CONFIG_FILENAME;
        log.info("LOCATION netbeans.home: " + this.location);
    }
}

