/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.integer;

import de.rub.nds.modifiablevariable.FileConfigurationException;
import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.integer.IntegerAddModification;
import de.rub.nds.modifiablevariable.integer.IntegerExplicitValueModification;
import de.rub.nds.modifiablevariable.integer.IntegerShiftLeftModification;
import de.rub.nds.modifiablevariable.integer.IntegerShiftRightModification;
import de.rub.nds.modifiablevariable.integer.IntegerSubtractModification;
import de.rub.nds.modifiablevariable.integer.IntegerXorModification;
import de.rub.nds.modifiablevariable.util.RandomHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class IntegerModificationFactory {
    private static final int MODIFICATION_COUNT = 7;
    private static final int MAX_MODIFICATION_VALUE = 32000;
    private static final int MAX_MODIFICATION_SHIFT_VALUE = 20;
    private static List<VariableModification<Integer>> modificationsFromFile;
    public static final String FILE_NAME = "de/rub/nds/modifiablevariable/explicit/integer.vec";

    public static IntegerAddModification add(String summand) {
        return IntegerModificationFactory.add(new Integer(summand));
    }

    public static IntegerAddModification add(Integer summand) {
        return new IntegerAddModification(summand);
    }

    public static IntegerShiftLeftModification shiftLeft(String shift) {
        return IntegerModificationFactory.shiftLeft(new Integer(shift));
    }

    public static IntegerShiftLeftModification shiftLeft(Integer shift) {
        return new IntegerShiftLeftModification(shift);
    }

    public static IntegerShiftRightModification shiftRight(String shift) {
        return IntegerModificationFactory.shiftRight(new Integer(shift));
    }

    public static IntegerShiftRightModification shiftRight(Integer shift) {
        return new IntegerShiftRightModification(shift);
    }

    public static VariableModification<Integer> sub(String subtrahend) {
        return IntegerModificationFactory.sub(new Integer(subtrahend));
    }

    public static VariableModification<Integer> sub(Integer subtrahend) {
        return new IntegerSubtractModification(subtrahend);
    }

    public static VariableModification<Integer> xor(String xor) {
        return IntegerModificationFactory.xor(new Integer(xor));
    }

    public static VariableModification<Integer> xor(Integer xor) {
        return new IntegerXorModification(xor);
    }

    public static VariableModification<Integer> explicitValue(String value) {
        return IntegerModificationFactory.explicitValue(new Integer(value));
    }

    public static VariableModification<Integer> explicitValue(Integer value) {
        return new IntegerExplicitValueModification(value);
    }

    public static VariableModification<Integer> explicitValueFromFile(int value) {
        List<VariableModification<Integer>> modifications = IntegerModificationFactory.modificationsFromFile();
        int pos = value % modifications.size();
        return modifications.get(pos);
    }

    public static synchronized List<VariableModification<Integer>> modificationsFromFile() {
        try {
            if (modificationsFromFile == null) {
                String line;
                modificationsFromFile = new LinkedList<VariableModification<Integer>>();
                ClassLoader classLoader = IntegerModificationFactory.class.getClassLoader();
                InputStream is = classLoader.getResourceAsStream(FILE_NAME);
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                while ((line = br.readLine()) != null) {
                    String value = line.trim().split(" ")[0];
                    modificationsFromFile.add(IntegerModificationFactory.explicitValue(value));
                }
            }
            return modificationsFromFile;
        }
        catch (IOException ex) {
            throw new FileConfigurationException("Modifiable variable file name could not have been found.", ex);
        }
    }

    public static VariableModification<Integer> createRandomModification() {
        Random random = RandomHelper.getRandom();
        int r = random.nextInt(7);
        int modification = random.nextInt(32000);
        int shiftModification = random.nextInt(20);
        VariableModification vm = null;
        switch (r) {
            case 0: {
                vm = new IntegerAddModification(modification);
                return vm;
            }
            case 1: {
                vm = new IntegerSubtractModification(modification);
                return vm;
            }
            case 2: {
                vm = new IntegerXorModification(modification);
                return vm;
            }
            case 3: {
                vm = new IntegerExplicitValueModification(modification);
                return vm;
            }
            case 4: {
                vm = new IntegerShiftLeftModification(shiftModification);
                return vm;
            }
            case 5: {
                vm = new IntegerShiftRightModification(shiftModification);
                return vm;
            }
            case 6: {
                vm = IntegerModificationFactory.explicitValueFromFile(random.nextInt(32000));
                return vm;
            }
        }
        return vm;
    }

    private IntegerModificationFactory() {
    }
}

