/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.command.checks.AbstractChecksStateModificationCommand;
import com.datical.liquibase.ext.command.checks.ChecksShowCommandStep;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;

public class ChecksDisableCommandStep
extends AbstractChecksStateModificationCommand {
    public static final String[] COMMAND_NAME = new String[]{"checks", "disable"};
    public static final CommandArgumentDefinition<String> CHECK_NAME_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_SETTINGS_FILE_ARG;

    @Override
    public final void run(CommandResultsBuilder commandResultsBuilder) {
        Object object = commandResultsBuilder.getCommandScope();
        String string = ((CommandScope)object).getConfiguredValue(CHECKS_SETTINGS_FILE_ARG).getValue();
        if (!this.doWork(commandResultsBuilder, string, (String)(object = ((CommandScope)object).getConfiguredValue(CHECK_NAME_ARG).getValue()))) {
            return;
        }
        Scope.getCurrentScope().getUI().sendMessage(String.format("\n\nCheck '%s' has been disabled.\n", object));
        ChecksShowCommandStep.writeTableToOutput(commandResultsBuilder, string, false);
        commandResultsBuilder.addResult("statusCode", (Object)0);
    }

    @Override
    public boolean validateStateModification(AbstractConfigurableRule object, String string) {
        if (!((AbstractConfigurableRule)object).isEnabled()) {
            object = String.format("\n\nCheck '%s' is already disabled.  No changes made.\n", string);
            Scope.getCurrentScope().getUI().sendMessage((String)object);
            return false;
        }
        return true;
    }

    @Override
    public void doStateModification(AbstractConfigurableRule abstractConfigurableRule) {
        abstractConfigurableRule.setEnabled(false);
    }

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("Disable an enabled check for current configuration");
        commandDefinition.setGroupShortDescription(new String[]{"checks"}, "Quality Checks commands");
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder(new String[][]{COMMAND_NAME});
        CHECK_NAME_ARG = commandBuilder.argument("checkName", String.class).required().description("Name of check to disable").build();
        CHECKS_SETTINGS_FILE_ARG = commandBuilder.argument("checksSettingsFile", String.class).description("Relative or fully qualified path to a configuration file for checks execution").build();
    }
}

