/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.netty.channel.Channel;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketAddress;
import java.util.Date;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Context;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.model.Position;

public class StbProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_LOGIN = 110;
    public static final int MSG_PROPERTY = 310;
    public static final int MSG_ALARM = 410;

    public StbProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, SocketAddress remoteAddress, int type, String deviceId, JsonObject root) throws JsonProcessingException {
        Response response = new Response();
        response.type = type + 1;
        response.deviceId = deviceId;
        response.result = 1;
        response.transaction = root.getString("txnNo");
        if (channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage(Context.getObjectMapper().writeValueAsString((Object)response), remoteAddress));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        JsonObject root = Json.createReader((Reader)new StringReader((String)msg)).readObject();
        int type = root.getInt("msgType");
        String deviceId = root.getString("devId");
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, deviceId);
        if (deviceSession == null) {
            return null;
        }
        this.sendResponse(channel, remoteAddress, type, deviceId, root);
        if (type == 310 || type == 410) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            if (type == 310) {
                int locationType = 0;
                block16: for (JsonValue property : root.getJsonArray("attrList")) {
                    String id;
                    JsonObject propertyObject = property.asJsonObject();
                    switch (id = propertyObject.getString("id")) {
                        case "01101001": {
                            locationType = Integer.parseInt(propertyObject.getString("value"));
                            continue block16;
                        }
                        case "01102001": {
                            position.setLongitude(Double.parseDouble(propertyObject.getString("value")));
                            continue block16;
                        }
                        case "01103001": {
                            position.setLatitude(Double.parseDouble(propertyObject.getString("value")));
                            continue block16;
                        }
                        case "01118001": {
                            position.set("deviceTemp", Double.parseDouble(propertyObject.getString("value")));
                            continue block16;
                        }
                        case "01122001": {
                            position.set("batteryControl", Integer.parseInt(propertyObject.getString("value")));
                            continue block16;
                        }
                        case "02301001": {
                            position.set("switchCabinetCommand", Integer.parseInt(propertyObject.getString("value")));
                            continue block16;
                        }
                    }
                    String key = "id" + id;
                    if (propertyObject.containsKey((Object)"doorId")) {
                        key = key + "Door" + propertyObject.getString("doorId");
                    }
                    position.set(key, propertyObject.getString("value"));
                }
                if (locationType > 0) {
                    position.setTime(new Date());
                    position.setValid(locationType != 5);
                    if (locationType == 2 || locationType == 4) {
                        position.setLongitude(-position.getLongitude());
                    }
                    if (locationType == 3 || locationType == 4) {
                        position.setLatitude(-position.getLatitude());
                    }
                } else {
                    this.getLastLocation(position, null);
                }
            }
            return position;
        }
        return null;
    }

    public static class Response {
        @JsonProperty(value="msgType")
        private int type;
        @JsonProperty(value="devId")
        private String deviceId;
        @JsonProperty(value="result")
        private int result;
        @JsonProperty(value="txnNo")
        private String transaction;
    }
}

