/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec.pattern;

import org.jparsec.pattern.CharPredicate;
import org.jparsec.pattern.Pattern;

class RepeatCharPredicatePattern
extends Pattern {
    private final int n;
    private final CharPredicate predicate;

    RepeatCharPredicatePattern(int n, CharPredicate predicate) {
        this.n = n;
        this.predicate = predicate;
    }

    @Override
    public int match(CharSequence src, int begin, int end) {
        return RepeatCharPredicatePattern.matchRepeat(this.n, this.predicate, src, end, begin, 0);
    }

    public String toString() {
        return this.predicate.toString() + '{' + this.n + '}';
    }

    static int matchRepeat(int n, CharPredicate predicate, CharSequence src, int length, int begin, int acc) {
        int end = begin + n;
        if (end > length) {
            return -1;
        }
        for (int i = begin; i < end; ++i) {
            if (predicate.isChar(src.charAt(i))) continue;
            return -1;
        }
        return n + acc;
    }
}

