/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec.pattern;

import org.jparsec.pattern.Pattern;

class UpperBoundedPattern
extends Pattern {
    private final int max;
    private final Pattern pattern;

    UpperBoundedPattern(int max, Pattern pattern) {
        this.max = max;
        this.pattern = pattern;
    }

    @Override
    public int match(CharSequence src, int begin, int end) {
        return UpperBoundedPattern.matchSome(this.max, this.pattern, src, end, begin, 0);
    }

    public String toString() {
        return this.pattern.toString() + "{0," + this.max + '}';
    }

    static int matchSome(int max, Pattern pattern, CharSequence src, int len, int from, int acc) {
        int begin = from;
        for (int i = 0; i < max; ++i) {
            int l = pattern.match(src, begin, len);
            if (-1 == l) {
                return begin - from + acc;
            }
            begin += l;
        }
        return begin - from + acc;
    }
}

