/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.util.Arrays;
import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.Value;

public class TupleExpression
extends Expression {
    Expression[] components;
    int[] evaluationModes;

    public TupleExpression(int width) {
        this.components = new Expression[width];
        this.evaluationModes = new int[width];
    }

    public void setExpression(int i, Expression exp) {
        this.components[i] = exp;
        this.adoptChildExpression(this.components[i]);
        this.evaluationModes[i] = -1;
    }

    public Expression[] getComponents() {
        return this.components;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = visitor.simplify(this.components[i]);
            this.adoptChildExpression(this.components[i]);
        }
        return this;
    }

    public Expression promote(PromotionOffer offer) throws XPathException {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = this.doPromotion(this.components[i], offer);
            this.adoptChildExpression(this.components[i]);
        }
        return this;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return new ExternalObjectType(Object.class, th.getConfiguration());
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = visitor.typeCheck(this.components[i], contextItemType);
            this.adoptChildExpression(this.components[i]);
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = visitor.optimize(this.components[i], contextItemType);
            this.adoptChildExpression(this.components[i]);
            this.evaluationModes[i] = i < 2 ? ExpressionTool.eagerEvaluationMode(this.components[i]) : ExpressionTool.lazyEvaluationMode(this.components[i]);
        }
        return this;
    }

    public Expression copy() {
        TupleExpression te = new TupleExpression(this.components.length);
        Expression[] c2 = new Expression[this.components.length];
        int[] e2 = new int[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            c2[i] = this.components[i].copy();
            e2[i] = this.evaluationModes[i];
        }
        te.components = c2;
        te.evaluationModes = e2;
        return te;
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("tuple");
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i].explain(out);
        }
        out.endElement();
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        Value[] tuple = new Value[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            tuple[i] = Value.asValue(ExpressionTool.evaluate(this.components[i], this.evaluationModes[i], context, 10));
        }
        return new ObjectValue(tuple);
    }

    public int computeCardinality() {
        return 16384;
    }

    public int getIntrinsicDependencies() {
        return 0;
    }

    public Iterator iterateSubExpressions() {
        return Arrays.asList(this.components).iterator();
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i] != original) continue;
            this.components[i] = replacement;
            found = true;
        }
        return found;
    }
}

