/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.toolwindow.actions;

import com.almworks.tracker.eapi.alpha.CollectionData;
import com.almworks.tracklink.toolwindow.Dashboard;
import com.almworks.tracklink.util.StringBundle;
import com.almworks.tracklink.util.Utils;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ui.Messages;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.Icon;

public class RemoveIssueCollectionAction
extends AnAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(AnActionEvent e) {
        try {
            Dashboard dashboard = Utils.getDashboard(e.getDataContext());
            if (dashboard == null) {
                e.getPresentation().setEnabled(false);
                return;
            }
            CollectionData selectedCollections = (CollectionData)dashboard.getData("DashboardSelection");
            e.getPresentation().setEnabled(selectedCollections != null);
        }
        finally {
            Utils.checkVisibility(e);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        Dashboard dashboard = Utils.getDashboard(e.getDataContext());
        if (dashboard == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        CollectionData selectedCollection = (CollectionData)dashboard.getData("DashboardSelection");
        if (selectedCollection == null) {
            return;
        }
        String name = "";
        name = (String)selectedCollection.getProperty(CollectionData.COLLECTION_NAME);
        String message = StringBundle.get("RemoveIssueCollection.Confirmation", name);
        String title = StringBundle.get("RemoveIssueCollection.Confirmation.Title", new Object[0]);
        int r = Messages.showYesNoDialog((Component)dashboard.getComponent(), (String)message, (String)title, (Icon)Messages.getQuestionIcon());
        if (r == 0) {
            ArrayList<CollectionData> data = new ArrayList<CollectionData>(1);
            data.add(selectedCollection);
            dashboard.getIssueMonitor().forgetCollections(data);
        }
    }
}

