/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.CancelConversionTaskRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CancelConversionTaskRequestMarshaller
implements Marshaller<Request<CancelConversionTaskRequest>, CancelConversionTaskRequest> {
    public Request<CancelConversionTaskRequest> marshall(CancelConversionTaskRequest cancelConversionTaskRequest) {
        if (cancelConversionTaskRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)cancelConversionTaskRequest, "AmazonEC2");
        request.addParameter("Action", "CancelConversionTask");
        request.addParameter("Version", "2015-04-15");
        if (cancelConversionTaskRequest.isDryRun() != null) {
            request.addParameter("DryRun", StringUtils.fromBoolean((Boolean)cancelConversionTaskRequest.isDryRun()));
        }
        if (cancelConversionTaskRequest.getConversionTaskId() != null) {
            request.addParameter("ConversionTaskId", StringUtils.fromString((String)cancelConversionTaskRequest.getConversionTaskId()));
        }
        if (cancelConversionTaskRequest.getReasonMessage() != null) {
            request.addParameter("ReasonMessage", StringUtils.fromString((String)cancelConversionTaskRequest.getReasonMessage()));
        }
        return request;
    }
}

