/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ctc;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ctc.EntitySearch;
import com.adobe.epubcheck.ctc.FileLinkSearch;
import com.adobe.epubcheck.ctc.TextSearch;
import com.adobe.epubcheck.ctc.epubpackage.EpubPackage;
import com.adobe.epubcheck.ctc.epubpackage.ManifestItem;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.util.SearchDictionary;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;

public class EpubTextContentCheck
implements DocumentValidator {
    private final Report report;
    private final EpubPackage epack;
    private final List<TextSearch> search;

    public EpubTextContentCheck(Report report, EpubPackage epack) {
        this.epack = epack;
        this.search = new ArrayList<TextSearch>();
        this.search.add(new EntitySearch(epack.getVersion(), epack.getZip(), report));
        this.search.add(new FileLinkSearch(epack.getVersion(), epack.getZip(), report));
        this.report = report;
    }

    @Override
    public boolean validate() {
        SearchDictionary validScriptTypes = new SearchDictionary(SearchDictionary.DictionaryType.VALID_TEXT_MEDIA_TYPES);
        for (int i = 0; i < this.epack.getManifest().itemsLength(); ++i) {
            ManifestItem itemEntry = this.epack.getManifest().getItem(i);
            if (!validScriptTypes.isValidMediaType(itemEntry.getMediaType())) continue;
            String fileToParse = this.epack.getManifestItemFileName(itemEntry);
            ZipEntry entry = this.epack.getZip().getEntry(fileToParse);
            if (entry == null) continue;
            for (TextSearch ts : this.search) {
                ts.Search(fileToParse);
            }
        }
        return true;
    }
}

