/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.iso9660;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.iso9660.ISO9660BaseVolume;
import ghidra.file.formats.iso9660.ISO9660BootRecordVolumeDescriptor;
import ghidra.file.formats.iso9660.ISO9660Directory;
import ghidra.file.formats.iso9660.ISO9660SetTerminator;
import ghidra.file.formats.iso9660.ISO9660VolumeDescriptor;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class ISO9660Header
implements StructConverter {
    private ArrayList<ISO9660BaseVolume> volumeDescriptorSet = new ArrayList();
    private HashMap<Integer, Short> typeLIndexSizeTable = new HashMap();
    private HashMap<Integer, Short> typeMIndexSizeTable = new HashMap();
    private HashMap<Integer, Short> supplTypeLIndexSizeTable = new HashMap();
    private HashMap<Integer, Short> supplTypeMIndexSizeTable = new HashMap();
    private ISO9660Directory directory;
    private ISO9660VolumeDescriptor primaryDesc;
    private byte type = (byte)-2;

    public ISO9660Header(BinaryReader reader) throws IOException {
        while (this.type != -1) {
            this.type = reader.readNextByte();
            reader.setPointerIndex(reader.getPointerIndex() - 1L);
            if (this.type == 0) {
                this.volumeDescriptorSet.add(new ISO9660BootRecordVolumeDescriptor(reader));
                continue;
            }
            if (this.type == 1) {
                this.primaryDesc = new ISO9660VolumeDescriptor(reader);
                this.directory = this.primaryDesc.getDirectoryEntry();
                this.volumeDescriptorSet.add(this.primaryDesc);
                this.typeLIndexSizeTable.put(this.primaryDesc.getTypeLPathTableLocation(), this.primaryDesc.getLogicalBlockSizeLE());
                this.typeMIndexSizeTable.put(this.primaryDesc.getTypeMPathTableLocation(), this.primaryDesc.getLogicalBlockSizeBE());
                if (!this.primaryDesc.getDirectoryEntry().isPaddingFieldPresent()) continue;
                reader.setPointerIndex(reader.getPointerIndex() - 1L);
                continue;
            }
            if (this.type != 2) continue;
            ISO9660VolumeDescriptor supplDesc = new ISO9660VolumeDescriptor(reader);
            this.volumeDescriptorSet.add(supplDesc);
            this.supplTypeLIndexSizeTable.put(supplDesc.getTypeLPathTableLocation(), supplDesc.getLogicalBlockSizeLE());
            this.supplTypeMIndexSizeTable.put(supplDesc.getTypeMPathTableLocation(), supplDesc.getLogicalBlockSizeBE());
            if (!supplDesc.getDirectoryEntry().isPaddingFieldPresent()) continue;
            reader.setPointerIndex(reader.getPointerIndex() - 1L);
        }
        this.volumeDescriptorSet.add(new ISO9660SetTerminator(reader));
    }

    public ISO9660Directory getPrimaryDirectory() {
        return this.directory;
    }

    public ArrayList<ISO9660BaseVolume> getVolumeDescriptorSet() {
        return this.volumeDescriptorSet;
    }

    public HashMap<Integer, Short> getTypeLIndexSizeTable() {
        return this.typeLIndexSizeTable;
    }

    public HashMap<Integer, Short> getTypeMIndexSizeTable() {
        return this.typeMIndexSizeTable;
    }

    public HashMap<Integer, Short> getSupplTypeLIndexSizeTable() {
        return this.supplTypeLIndexSizeTable;
    }

    public HashMap<Integer, Short> getSupplTypeMIndexSizeTable() {
        return this.supplTypeMIndexSizeTable;
    }

    public ISO9660VolumeDescriptor getPrimaryVolumeDescriptor() {
        return this.primaryDesc;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        for (ISO9660BaseVolume volume : this.volumeDescriptorSet) {
            buff.append(volume.toString());
        }
        return buff.toString();
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struc = new StructureDataType("ISO9660Header", 0);
        for (ISO9660BaseVolume volume : this.volumeDescriptorSet) {
            DataType data = volume.toDataType();
            struc.add(data);
        }
        return struc;
    }
}

