/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ActionContext;
import docking.ComponentPlaceholder;
import docking.DockingWindowManager;
import docking.ShowComponentAction;
import docking.action.MenuData;
import ghidra.util.HelpLocation;
import java.util.List;

public class ShowAllComponentsAction
extends ShowComponentAction {
    private final List<ComponentPlaceholder> infoList;

    public ShowAllComponentsAction(DockingWindowManager winMgr, List<ComponentPlaceholder> infoList, String subMenuName) {
        super(winMgr, "Show All", subMenuName);
        this.infoList = infoList;
        String group = "Z";
        this.setMenuBarData(new MenuData(new String[]{"&Window", subMenuName, "Show All"}, EMPTY_ICON, group));
        winMgr.doSetMenuGroup(new String[]{"&Window", subMenuName}, "Permanent");
        this.setHelpLocation(new HelpLocation("DockingWindows", "Windows_Menu"));
    }

    @Override
    public void actionPerformed(ActionContext context) {
        boolean focusMe = true;
        for (ComponentPlaceholder info : this.infoList) {
            this.winMgr.showComponent(info, true, focusMe, true);
            focusMe = false;
        }
    }
}

