/*
 * Decompiled with CFR 0.152.
 */
package docking.options.editor;

import docking.help.Help;
import docking.help.HelpService;
import docking.options.editor.GenericOptionsComponent;
import ghidra.framework.options.EditorState;
import ghidra.framework.options.EditorStateFactory;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsEditor;
import ghidra.util.HelpLocation;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.layout.VerticalLayout;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class OptionsEditorPanel
extends JPanel
implements OptionsEditor {
    private EditorStateFactory editorStateFactory;
    private Options options;
    private List<String> optionNames;
    private PropertyChangeListener propertyChangeListener;
    private List<EditorState> editorInfoList;
    private PropertyChangeListener editorPropertyChangeListener = new EditorPropertyChangeListener();
    private final String title;

    public OptionsEditorPanel(String title, Options options, List<String> optionNames, EditorStateFactory editorStateFactory) {
        if (optionNames.size() == 0) {
            throw new AssertException("No editable options given for this panel.");
        }
        this.options = options;
        this.editorStateFactory = editorStateFactory;
        this.optionNames = optionNames;
        this.title = title;
        Collections.sort(optionNames);
        this.create();
    }

    public void dispose() {
        this.propertyChangeListener = null;
        this.editorInfoList.clear();
    }

    private void create() {
        this.setLayout((LayoutManager)new VerticalLayout(4));
        this.editorInfoList = new ArrayList<EditorState>(this.optionNames.size());
        ArrayList<GenericOptionsComponent> compList = new ArrayList<GenericOptionsComponent>();
        this.createBorder();
        HelpService help = Help.getHelpService();
        for (String optionName : this.optionNames) {
            EditorState editorState = this.editorStateFactory.getEditorState(this.options, optionName, this.editorPropertyChangeListener);
            this.editorInfoList.add(editorState);
            HelpLocation helpLoc = this.options.getHelpLocation(optionName);
            GenericOptionsComponent component = GenericOptionsComponent.createOptionComponent(editorState);
            this.add(component);
            if (helpLoc == null) {
                help.excludeFromHelp(component);
            } else {
                help.registerHelp(component, helpLoc);
            }
            compList.add(component);
        }
        GenericOptionsComponent.alignLabels(compList);
    }

    private void createBorder() {
        Border emptyBorder = BorderFactory.createEmptyBorder(20, 20, 20, 20);
        TitledBorder titleBorder = BorderFactory.createTitledBorder(this.title);
        CompoundBorder border = BorderFactory.createCompoundBorder(titleBorder, emptyBorder);
        this.setBorder(border);
    }

    public void apply() throws InvalidInputException {
        for (EditorState state : this.editorInfoList) {
            state.applyValue();
        }
    }

    public void cancel() {
    }

    public void reload() {
    }

    public JComponent getEditorComponent(Options o, EditorStateFactory factory) {
        return this;
    }

    public void setOptionsPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListener = listener;
    }

    private class EditorPropertyChangeListener
    implements PropertyChangeListener {
        private EditorPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.checkForDifferences() && OptionsEditorPanel.this.propertyChangeListener != null) {
                OptionsEditorPanel.this.propertyChangeListener.propertyChange(new PropertyChangeEvent(this, "apply.enabled", null, Boolean.TRUE));
            }
        }

        private boolean checkForDifferences() {
            for (EditorState info : OptionsEditorPanel.this.editorInfoList) {
                if (!info.isValueChanged()) continue;
                return true;
            }
            return false;
        }
    }
}

