/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.app.cmd.function.AddParameterCommand;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.InvalidInputException;

public class AddMemoryParameterCommand
extends AddParameterCommand {
    private Address memAddr;
    private String name;
    private DataType dataType;

    public AddMemoryParameterCommand(Function function, Address memAddr, String name, DataType dataType, int ordinal, SourceType source) {
        super(function, ordinal, source);
        this.memAddr = memAddr;
        this.name = name;
        this.dataType = dataType;
        this.ordinal = ordinal;
    }

    @Override
    protected Parameter getParameter(Program program) throws InvalidInputException {
        return new ParameterImpl(this.name, this.dataType, this.memAddr, program);
    }

    @Override
    public String getName() {
        return "Create Memory Parameter";
    }
}

