/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge;

import docking.widgets.label.GDLabel;
import docking.widgets.label.GIconLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SpringLayout;
import javax.swing.Timer;
import resources.ResourceManager;

public class PhaseProgressPanel
extends JPanel {
    private static final String DEFAULT_INFO = "Merge programs in progress...";
    private ImageIcon INFORM_ICON = ResourceManager.loadImage((String)"images/information.png");
    private JLabel titleLabel;
    private JProgressBar progressBar;
    private JPanel progressMessagePanel;
    private JLabel messageIcon;
    private JLabel messageLabel;
    private boolean isShowingProgress = false;
    private boolean isShowingMessage = false;
    private String title;
    private SpringLayout progressLayout;
    private Timer updateTimer;
    private boolean isTimerRunning;
    private String message;
    private int progress;
    private int lastProgress = -1;

    public PhaseProgressPanel(String title) {
        this.title = title;
        this.progressLayout = new SpringLayout();
        this.setLayout(this.progressLayout);
        this.createProgressPanel();
        this.adjustPreferredSize();
    }

    private void adjustPreferredSize() {
        int width = this.titleLabel.getPreferredSize().width + 5;
        int height = this.titleLabel.getPreferredSize().height + 5;
        if (this.isShowingProgress) {
            height += 5;
            height += this.progressBar.getPreferredSize().height;
            width = Math.max(width, this.progressBar.getPreferredSize().width);
        }
        if (this.isShowingMessage) {
            height += 5;
            height += this.progressMessagePanel.getPreferredSize().height;
            width = Math.max(width, this.progressMessagePanel.getPreferredSize().width);
        }
        this.setPreferredSize(new Dimension(width, height));
    }

    private void createProgressPanel() {
        this.titleLabel = new GDLabel(this.title);
        this.add(this.titleLabel);
        this.progressLayout.putConstraint("West", (Component)this.titleLabel, 5, "West", (Component)this);
        this.progressLayout.putConstraint("North", (Component)this.titleLabel, 5, "North", (Component)this);
        this.progressBar = new JProgressBar(0);
        Dimension dim = this.progressBar.getPreferredSize();
        this.progressBar.setPreferredSize(new Dimension(500, (int)dim.getHeight()));
        this.progressBar.setMaximum(100);
        this.progressLayout.putConstraint("North", (Component)this.progressBar, 5, "South", (Component)this.titleLabel);
        this.progressLayout.putConstraint("West", (Component)this.progressBar, 0, "West", (Component)this.titleLabel);
        this.doSetProgress(0);
        this.progressMessagePanel = new JPanel(new BorderLayout());
        this.messageIcon = new GIconLabel((Icon)this.INFORM_ICON);
        this.messageIcon.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.messageLabel = new GDLabel(DEFAULT_INFO);
        this.progressMessagePanel.add((Component)this.messageIcon, "West");
        this.progressMessagePanel.add((Component)this.messageLabel, "Center");
        this.doSetMessage(DEFAULT_INFO);
        this.updateTimer = new Timer(250, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhaseProgressPanel.this.update();
            }
        });
    }

    private synchronized void update() {
        boolean changed = false;
        if (this.message != null) {
            this.doSetMessage(this.message);
            this.message = null;
            changed = true;
        }
        if (this.progress != this.lastProgress) {
            this.doSetProgress(this.progress);
            this.lastProgress = this.progress;
            changed = true;
        }
        if (!changed) {
            this.updateTimer.stop();
            this.isTimerRunning = false;
        }
    }

    private void doValidate() {
        this.invalidate();
        this.repaint();
        this.adjustPreferredSize();
    }

    public void setTitle(String newTitle) {
        this.titleLabel.setText(newTitle);
        this.doValidate();
    }

    private void doSetMessage(String newMessage) {
        this.messageLabel.setText(newMessage);
        if (!this.isShowingMessage) {
            this.add(this.progressMessagePanel);
            this.progressLayout.putConstraint("West", (Component)this.progressMessagePanel, 0, "West", (Component)this.titleLabel);
            this.progressLayout.putConstraint("North", (Component)this.progressMessagePanel, 5, "South", (Component)(this.isShowingProgress ? this.progressBar : this.titleLabel));
            this.isShowingMessage = true;
        }
        this.doValidate();
    }

    public synchronized void setMessage(String message) {
        this.message = message;
        if (!this.isTimerRunning) {
            this.updateTimer.start();
            this.isTimerRunning = true;
        }
    }

    private void doSetProgress(int progressPercentage) {
        if (progressPercentage < 0 || progressPercentage > 100) {
            throw new RuntimeException("Invalid progress value (" + progressPercentage + "). Must be from 0 to 100.");
        }
        if (!this.isShowingProgress) {
            this.add(this.progressBar);
            this.isShowingProgress = true;
        }
        this.progressBar.setValue(progressPercentage);
        this.doValidate();
    }

    public synchronized void setProgress(int progressPercentage) {
        this.progress = progressPercentage;
        if (!this.isTimerRunning) {
            this.updateTimer.start();
            this.isTimerRunning = true;
        }
    }

    public void removeMessage() {
        this.remove(this.progressMessagePanel);
        this.isShowingMessage = false;
        this.doValidate();
    }

    public void removeProgress() {
        this.remove(this.progressBar);
        if (this.isShowingMessage) {
            this.progressLayout.putConstraint("North", (Component)this.messageIcon, 5, "South", (Component)this.titleLabel);
        }
        this.isShowingProgress = false;
        this.doValidate();
    }
}

