/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser.hover;

import ghidra.app.plugin.core.codebrowser.hover.ListingHoverService;
import ghidra.app.plugin.core.hover.AbstractReferenceHover;
import ghidra.app.services.CodeFormatService;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;

public class ReferenceListingHover
extends AbstractReferenceHover
implements ListingHoverService {
    protected static final String NAME = "Reference Code Viewer";
    private static final String DESCRIPTION = "Shows \"referred to\" code and data within the listing.";
    private static final int PRIORITY = 50;

    public ReferenceListingHover(PluginTool tool) {
        this(tool, null);
    }

    public ReferenceListingHover(PluginTool tool, CodeFormatService codeFormatSvc) {
        super(tool, codeFormatSvc, 50);
    }

    @Override
    public void initializeOptions() {
        this.options = this.tool.getOptions("Listing Popups");
        this.options.setOptionsHelpLocation(new HelpLocation("CodeBrowserPlugin", "MouseHover"));
        HelpLocation help = new HelpLocation("CodeBrowserPlugin", "ReferenceHover");
        this.options.getOptions(NAME).setOptionsHelpLocation(help);
        this.options.registerOption(NAME, (Object)true, help, DESCRIPTION);
        this.options.registerOption("Reference Code Viewer.Dialog Height", (Object)400, help, "Height of the popup window");
        this.options.registerOption("Reference Code Viewer.Dialog Width", (Object)600, help, "Width of the popup window");
        this.setOptions((Options)this.options, NAME);
        this.options.addOptionsChangeListener((OptionsChangeListener)this);
    }
}

