/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.pathmanager.PathManager;
import generic.util.Path;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.util.HelpLocation;
import java.util.List;

public class EditArchivePathAction
extends DockingAction {
    private final DataTypeManagerPlugin plugin;

    public EditArchivePathAction(DataTypeManagerPlugin plugin) {
        super("Edit Archive Paths", plugin.getName());
        this.plugin = plugin;
        this.setMenuBarData(new MenuData(new String[]{"Edit Archive Paths..."}, null, "R2"));
        this.setDescription("Opens the options editor for adding paths that will be searched when attempting to locate archive files.");
        this.setEnabled(true);
        this.setHelpLocation(new HelpLocation(plugin.getName(), "Edit_Archive_Paths"));
    }

    public void actionPerformed(ActionContext context) {
        PathManagerDialog pathManagerDialog = new PathManagerDialog();
        this.plugin.getTool().showDialog((DialogComponentProvider)pathManagerDialog);
    }

    class PathManagerDialog
    extends DialogComponentProvider {
        private PathManager pathManager;

        protected PathManagerDialog() {
            super("Edit Data Type Archive Paths");
            this.pathManager = new PathManager(false, true);
            this.pathManager.setFileChooserProperties("Select Archive Directory", "LastOpenedArchiveDirectory", GhidraFileChooserMode.DIRECTORIES_ONLY, false, null);
            this.setHelpLocation(new HelpLocation("DataTypeManagerPlugin", "Edit_Archive_Paths_Dialog"));
            this.pathManager.restoreFromPreferences("DATATYPE_ARCHIVE_PATHS", null, "DISABLED_DATA_TYPE_ARCHIVE_PATH");
            this.addWorkPanel(this.pathManager.getComponent());
            this.addOKButton();
            this.addCancelButton();
        }

        protected void okCallback() {
            this.pathManager.saveToPreferences("DATATYPE_ARCHIVE_PATHS", "DISABLED_DATA_TYPE_ARCHIVE_PATH");
            this.close();
        }

        public void close() {
            super.close();
            this.pathManager.dispose();
        }

        List<Path> getPaths() {
            return this.pathManager.getPaths();
        }
    }
}

