/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.equate;

import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.equate.ConvertCommand;
import ghidra.app.plugin.core.equate.EquatePlugin;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JMenuItem;

public abstract class AbstractConvertAction
extends ListingContextAction {
    protected final EquatePlugin plugin;
    private FontMetrics metrics;
    private final boolean isSigned;

    public AbstractConvertAction(EquatePlugin plugin, String actionName, boolean isSigned) {
        super(actionName, plugin.getName());
        this.plugin = plugin;
        this.isSigned = isSigned;
        this.setPopupMenuData(new MenuData(new String[]{"Convert", ""}, "Convert"));
        this.setEnabled(true);
    }

    @Override
    public boolean isEnabledForContext(ListingActionContext context) {
        String menuName;
        ProgramLocation loc = context.getLocation();
        if (!(loc instanceof OperandFieldLocation)) {
            return false;
        }
        Scalar scalar = this.plugin.getScalar(context);
        if (scalar == null) {
            return false;
        }
        if (this.isSigned && scalar.getSignedValue() >= 0L) {
            return false;
        }
        CodeUnit cu = this.plugin.getCodeUnit(context);
        if (cu instanceof Data) {
            if (this.getFormatChoice() == -1) {
                return false;
            }
            Data data = (Data)cu;
            if (!data.isDefined()) {
                return false;
            }
            DataType dataType = data.getBaseDataType();
            if (!(dataType instanceof AbstractIntegerDataType)) {
                return false;
            }
        }
        if ((menuName = this.getMenuName(context.getProgram(), scalar, cu instanceof Data)) == null) {
            return false;
        }
        this.getPopupMenuData().setMenuItemName(menuName);
        return true;
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        ConvertCommand cmd = new ConvertCommand(this, context);
        if (context.hasSelection()) {
            this.plugin.getTool().executeBackgroundCommand((BackgroundCommand)cmd, (UndoableDomainObject)context.getProgram());
        } else {
            this.plugin.getTool().execute((Command)cmd, (DomainObject)context.getProgram());
        }
    }

    protected abstract String getMenuName(Program var1, Scalar var2, boolean var3);

    protected abstract String convertToString(Program var1, Scalar var2, boolean var3);

    protected int getFormatChoice() {
        return -1;
    }

    protected final boolean isSignedChoice() {
        return this.isSigned;
    }

    private int stringWidth(String s) {
        int w;
        if (this.metrics == null) {
            JMenuItem item = new JMenuItem();
            Font font = item.getFont();
            this.metrics = this.plugin.getTool().getActiveWindow().getFontMetrics(font);
        }
        if ((w = this.metrics.stringWidth(s)) == 0) {
            return 10 * s.length();
        }
        return w;
    }

    String getStandardLengthString(String baseString) {
        int spaceWidth;
        int baseWidth = this.stringWidth(baseString);
        int paddingSize = (140 - baseWidth) / (spaceWidth = this.stringWidth(" "));
        if (paddingSize <= 0) {
            return baseString;
        }
        StringBuilder buf = new StringBuilder(baseString);
        for (int i = 0; i < paddingSize; ++i) {
            buf.append(" ");
        }
        return buf.toString();
    }
}

