/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.instructionsearch.ui;

import docking.widgets.OptionDialog;
import ghidra.app.plugin.core.instructionsearch.InstructionSearchPlugin;
import ghidra.app.plugin.core.instructionsearch.model.InstructionMetadata;
import ghidra.app.plugin.core.instructionsearch.ui.InstructionSearchDialog;
import ghidra.program.model.address.AddressRange;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

class SearchAllInstructionsTask
extends Task {
    private InstructionSearchDialog searchDialog;
    private InstructionSearchPlugin searchPlugin;

    SearchAllInstructionsTask(InstructionSearchDialog searchDialog, InstructionSearchPlugin searchPlugin) {
        super("Searching Program Text", true, true, false);
        this.searchDialog = searchDialog;
        this.searchPlugin = searchPlugin;
    }

    public void run(TaskMonitor monitor) {
        if (monitor == null) {
            return;
        }
        monitor.setShowProgressValue(false);
        List<InstructionMetadata> results = this.doSearch(monitor);
        if (!monitor.isCancelled()) {
            this.searchDialog.displaySearchResults(results);
        } else {
            if (results.isEmpty()) {
                return;
            }
            int option = OptionDialog.showYesNoDialog((Component)this.searchDialog.getFocusComponent(), (String)"Results found!", (String)(results.size() + " match(es) found. View results?"));
            if (option == 1) {
                this.searchDialog.displaySearchResults(results);
            }
        }
    }

    public List<InstructionMetadata> doSearch(TaskMonitor taskMonitor) {
        List<AddressRange> searchRanges = this.searchDialog.getControlPanel().getRangeWidget().getSearchRange();
        ArrayList<InstructionMetadata> retList = new ArrayList<InstructionMetadata>();
        int rangeNum = 1;
        for (AddressRange range : searchRanges) {
            taskMonitor.setProgress(0L);
            taskMonitor.setMaximum(range.getLength());
            if (searchRanges.size() > 1) {
                taskMonitor.setMessage("Searching range " + rangeNum + " of " + searchRanges.size());
            } else {
                taskMonitor.setMessage("Searching...");
            }
            List<InstructionMetadata> meta = this.searchDialog.getSearchData().search(this.searchPlugin.getCurrentProgram(), range, taskMonitor);
            retList.addAll(meta);
            ++rangeNum;
        }
        return retList;
    }
}

