/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework;

import generic.jar.ResourceFile;
import ghidra.GhidraClassLoader;
import ghidra.GhidraLauncher;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.framework.ModuleInitializer;
import ghidra.framework.preferences.Preferences;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.util.Set;

public class HeadlessGhidraApplicationConfiguration
extends ApplicationConfiguration {
    protected void initializeApplication() {
        super.initializeApplication();
        this.addUserJarAndPluginPathsToClasspath();
        this.monitor.setMessage("Performing class searching...");
        this.performClassSearching();
        this.locateCACertsFile();
        this.monitor.setMessage("Performing module initialization...");
        this.performModuleInitialization();
        this.monitor.setMessage("Done initializing");
    }

    private void addUserJarAndPluginPathsToClasspath() {
        if (Application.inSingleJarMode()) {
            return;
        }
        if (!(ClassLoader.getSystemClassLoader() instanceof GhidraClassLoader)) {
            return;
        }
        GhidraClassLoader loader = (GhidraClassLoader)ClassLoader.getSystemClassLoader();
        String userJarDir = Preferences.getProperty((String)"UserPluginJarDirectory");
        if (userJarDir != null) {
            GhidraLauncher.findJarsInDir((ResourceFile)new ResourceFile(userJarDir)).forEach(p -> loader.addPath(p));
        }
        String userSettingsPath = Application.getUserSettingsDirectory().getAbsolutePath();
        String pluginPath = userSettingsPath + File.separatorChar + "plugins";
        loader.addPath(pluginPath);
        GhidraLauncher.findJarsInDir((ResourceFile)new ResourceFile(pluginPath)).forEach(p -> loader.addPath(p));
        for (String path : Preferences.getPluginPaths()) {
            loader.addPath(path);
        }
    }

    private void performClassSearching() {
        try {
            ClassSearcher.search((boolean)false, (TaskMonitor)this.monitor);
        }
        catch (CancelledException e) {
            Msg.debug((Object)((Object)this), (Object)"Class searching unexpectedly cancelled.");
        }
    }

    private void locateCACertsFile() {
        for (ResourceFile appRoot : Application.getApplicationRootDirectories()) {
            File cacertsFile = new File(appRoot.getAbsolutePath(), "cacerts");
            if (!cacertsFile.isFile()) continue;
            System.setProperty("ghidra.cacerts", cacertsFile.getAbsolutePath());
            break;
        }
    }

    private void performModuleInitialization() {
        Set instances = ClassSearcher.getInstances(ModuleInitializer.class);
        for (ModuleInitializer initializer : instances) {
            this.monitor.setMessage("Initializing " + initializer.getName() + "...");
            initializer.run();
        }
    }
}

