/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import docking.ComponentProvider;
import ghidra.app.nav.LocationMemento;
import ghidra.app.nav.Navigatable;
import ghidra.app.nav.NavigatableRemovalListener;
import ghidra.app.services.GoToService;
import ghidra.framework.data.ToolState;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;

public class GhidraToolState
extends ToolState
implements NavigatableRemovalListener {
    private ComponentProvider activeProvider;
    private LocationMemento beforeMemento;
    private LocationMemento afterMemento;
    private Navigatable navigatable = this.getNavigatable();

    public GhidraToolState(PluginTool tool, DomainObject domainObject) {
        super(tool, domainObject);
        if (this.navigatable != null) {
            LocationMemento memento = this.navigatable.getMemento();
            if (memento.isValid()) {
                this.beforeMemento = memento;
            }
            this.navigatable.addNavigatableListener(this);
        }
    }

    @Override
    public void navigatableRemoved(Navigatable nav) {
        this.navigatable = null;
        this.beforeMemento = null;
        this.afterMemento = null;
    }

    private Navigatable getNavigatable() {
        Navigatable nav;
        this.activeProvider = this.tool.getActiveComponentProvider();
        if (this.activeProvider instanceof Navigatable && !(nav = (Navigatable)this.activeProvider).isConnected()) {
            return nav;
        }
        GoToService service = (GoToService)this.tool.getService(GoToService.class);
        if (service != null) {
            return service.getDefaultNavigatable();
        }
        return null;
    }

    public void getAfterState(DomainObject domainObject) {
        LocationMemento memento;
        super.getAfterState(domainObject);
        if (this.navigatable != null && (memento = this.navigatable.getMemento()).isValid()) {
            this.afterMemento = memento;
        }
    }

    public void restoreAfterRedo(DomainObject domainObject) {
        super.restoreAfterRedo(domainObject);
        if (this.navigatable != null && this.afterMemento != null) {
            this.navigatable.goTo(this.afterMemento.getProgram(), this.afterMemento.getProgramLocation());
            this.navigatable.setMemento(this.afterMemento);
            this.updateFocus();
        }
    }

    public void restoreAfterUndo(DomainObject domainObject) {
        super.restoreAfterUndo(domainObject);
        if (this.navigatable != null && this.beforeMemento != null) {
            this.navigatable.goTo(this.beforeMemento.getProgram(), this.beforeMemento.getProgramLocation());
            this.navigatable.setMemento(this.beforeMemento);
            this.updateFocus();
        }
    }

    private void updateFocus() {
        if (this.activeProvider != null) {
            this.activeProvider.requestFocus();
        }
    }
}

