/*
 * Decompiled with CFR 0.152.
 */
package mdemangler;

import java.nio.charset.Charset;
import mdemangler.MDEncodedNumber;
import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.MDParsableItem;

public class MDString
extends MDParsableItem {
    private String name;
    private byte[] byteArray;
    private String byteString;
    private char charType;
    private int typeSize;
    private boolean crcPass;
    private int lenVal;
    private long crcVal;
    private boolean hasAddr = false;
    private long addrVal = 0L;

    public MDString(MDMang dmang) {
        super(dmang);
    }

    @Override
    public void insert(StringBuilder builder) {
        this.dmang.insert(builder, this);
    }

    public boolean isUnicode() {
        return this.charType == '1';
    }

    public byte[] getBytes() {
        return this.byteArray;
    }

    public int getLength() {
        return this.lenVal;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasAddress() {
        return this.hasAddr;
    }

    public long getAddress() {
        return this.addrVal;
    }

    public String getString(Charset charset8, Charset charset16) {
        if (this.byteString == null) {
            switch (this.typeSize) {
                case 2: {
                    this.byteString = new String(this.byteArray, charset16);
                    break;
                }
                default: {
                    this.byteString = new String(this.byteArray, charset8);
                }
            }
            for (int index = 0; index < this.byteString.length(); ++index) {
                if (this.byteString.charAt(index) != '\u0000') continue;
                this.byteString = this.byteString.substring(0, index);
                break;
            }
        }
        return this.byteString;
    }

    public boolean crcPass() {
        return this.crcPass;
    }

    @Override
    protected void parseInternal() throws MDException {
        this.name = "";
        if (this.dmang.getAndIncrement() != '@') {
            throw new MDException("MDString parse error: missing @");
        }
        if (this.dmang.getAndIncrement() != '_') {
            throw new MDException("MDString parse error: missing _");
        }
        this.charType = this.dmang.getAndIncrement();
        MDEncodedNumber len = new MDEncodedNumber(this.dmang);
        len.parse();
        this.lenVal = len.getValue().intValue();
        MDEncodedNumber crcNumber = new MDEncodedNumber(this.dmang);
        crcNumber.parse();
        this.crcVal = crcNumber.getValue().longValue();
        switch (this.charType) {
            case '0': {
                this.typeSize = 1;
                this.name = "`string'";
                break;
            }
            case '1': {
                this.typeSize = 2;
                this.name = "`string'";
                break;
            }
            default: {
                this.typeSize = 1;
                this.name = "`string'";
            }
        }
        if (this.lenVal % this.typeSize != 0) {
            // empty if block
        }
        this.parseByteArray();
        if (this.dmang.peek() != '\uffff') {
            MDEncodedNumber addr = new MDEncodedNumber(this.dmang);
            addr.parse();
            this.addrVal = addr.getValue().longValue();
            this.hasAddr = true;
        }
        if (this.lenVal <= 32 * this.typeSize) {
            CrcChecker checker = new CrcChecker();
            this.crcPass = checker.crcCheck(this.byteArray, this.crcVal, this.typeSize);
        } else {
            this.crcPass = true;
        }
    }

    private byte parseByte() throws MDException {
        byte b;
        block19: {
            char c;
            block20: {
                block22: {
                    block21: {
                        block18: {
                            b = 0;
                            c = this.dmang.getAndIncrement();
                            if (!Character.isLetter(c) && !Character.isDigit(c) && c != '_' && c != '$') break block18;
                            b = (byte)c;
                            break block19;
                        }
                        if (c != '?') break block20;
                        if (this.dmang.peek() == '\uffff') {
                            throw new MDException("MDString parse error: not enough data");
                        }
                        c = this.dmang.getAndIncrement();
                        if (c < 'a' || c > 'z') break block21;
                        b = (byte)(c - 97 + 225);
                        break block19;
                    }
                    if (c < 'A' || c > 'Z') break block22;
                    b = (byte)(c - 65 + 193);
                    break block19;
                }
                switch (c) {
                    case '0': {
                        b = (byte)44;
                        break block19;
                    }
                    case '1': {
                        b = (byte)47;
                        break block19;
                    }
                    case '2': {
                        b = (byte)92;
                        break block19;
                    }
                    case '3': {
                        b = (byte)58;
                        break block19;
                    }
                    case '4': {
                        b = (byte)46;
                        break block19;
                    }
                    case '5': {
                        b = (byte)32;
                        break block19;
                    }
                    case '6': {
                        b = (byte)10;
                        break block19;
                    }
                    case '7': {
                        b = (byte)9;
                        break block19;
                    }
                    case '8': {
                        b = (byte)39;
                        break block19;
                    }
                    case '9': {
                        b = (byte)45;
                        break block19;
                    }
                    case '$': {
                        if (this.dmang.peek() == '\uffff') {
                            throw new MDException("MDString parse error: not enough data");
                        }
                        c = this.dmang.getAndIncrement();
                        if (c < 'A' || c > 'P') {
                            throw new MDException("MDString parse error: invalid hex code:" + c);
                        }
                        b = (byte)(c - 65 << 4);
                        if (this.dmang.peek() == '\uffff') {
                            throw new MDException("MDString parse error: not enough data");
                        }
                        c = this.dmang.getAndIncrement();
                        if (c < 'A' || c > 'P') {
                            throw new MDException("MDString parse error: invalid hex code:" + c);
                        }
                        b = (byte)(b | (byte)(c - 65));
                        break block19;
                    }
                    default: {
                        throw new MDException("MDString parse error: invalid code2: " + c);
                    }
                }
            }
            throw new MDException("MDString parse error: invalid code1:" + c);
        }
        return b;
    }

    private void parseByteArray() throws MDException {
        this.byteArray = new byte[this.lenVal];
        int index = 0;
        while (this.dmang.peek() != '@' && index < this.lenVal) {
            this.byteArray[index++] = this.parseByte();
        }
        this.dmang.increment();
    }

    private class CrcChecker {
        long crc;

        private CrcChecker() {
        }

        private long reflectBits(long val) {
            int i = 0;
            long newVal = 0L;
            for (i = 0; i < 32; ++i) {
                newVal >>= 1;
                newVal |= val & 0x80000000L;
                val <<= 1;
            }
            return newVal;
        }

        private void crcCalc(byte val) {
            long longByte = val;
            for (int i = 0; i < 8; ++i) {
                this.crc <<= 1;
                if (((this.crc >> 32 ^ longByte) & 1L) != 0L) {
                    this.crc ^= 0x4C11DB7L;
                }
                longByte >>= 1;
            }
        }

        private boolean crcCheck(byte[] bytes, long crcTest, int size) {
            this.crc = 0xFFFFFFFFL;
            for (int index = 0; index < bytes.length; index += size) {
                for (int internalIndex = size - 1; internalIndex >= 0; --internalIndex) {
                    this.crcCalc(bytes[index + internalIndex]);
                }
            }
            this.crc &= 0xFFFFFFFFL;
            this.crc = this.reflectBits(this.crc);
            return this.crc == crcTest;
        }
    }
}

