/*
 * Decompiled with CFR 0.152.
 */
package generic.test;

import generic.test.TestExceptionTracker;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ConcurrentTestExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final String[] IGNORABLE_ERROR_MESSAGES = new String[]{"DerivedColor$UIResource cannot be cast to", "FontUIResource cannot be cast to javax.swing.Painter"};
    private static final List<TestExceptionTracker> throwables = Collections.synchronizedList(new ArrayList());
    private static volatile boolean enabled = true;

    public static void registerHandler() {
        SystemUtilities.runSwingLater(() -> Thread.setDefaultUncaughtExceptionHandler(new ConcurrentTestExceptionHandler()));
    }

    public static synchronized void handle(Thread thread, Throwable t) {
        if (!enabled) {
            return;
        }
        if (t instanceof InvocationTargetException) {
            t = t.getCause();
        }
        if (ConcurrentTestExceptionHandler.isKnownTestMachineTimingBug(t)) {
            Msg.error(ConcurrentTestExceptionHandler.class, (Object)"Found known Java Swing timing bug.  Reporting, but not failing.", (Throwable)t);
            return;
        }
        TestExceptionTracker tracker = new TestExceptionTracker(thread.getName(), t);
        throwables.add(tracker);
        ConcurrentTestExceptionHandler.class.notifyAll();
    }

    private static boolean isKnownTestMachineTimingBug(Throwable t) {
        String message = t.getMessage();
        if (message == null) {
            return false;
        }
        return StringUtils.containsAny((CharSequence)message, (CharSequence[])IGNORABLE_ERROR_MESSAGES);
    }

    public static synchronized void clear() {
        throwables.clear();
    }

    public static synchronized void enable() {
        enabled = true;
    }

    public static synchronized void disable() {
        enabled = false;
    }

    public static synchronized boolean isEnabled() {
        return enabled;
    }

    public static synchronized List<TestExceptionTracker> getExceptions() {
        return new ArrayList<TestExceptionTracker>(throwables);
    }

    public static synchronized boolean hasException() {
        return !throwables.isEmpty();
    }

    @Override
    public void uncaughtException(Thread thread, Throwable t) {
        ConcurrentTestExceptionHandler.handle(thread, t);
    }
}

