/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.task;

import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;

public class UnknownProgressWrappingTaskMonitor
extends TaskMonitorAdapter {
    private TaskMonitor delegate;

    public UnknownProgressWrappingTaskMonitor(TaskMonitor delegate, long startMaximum) {
        this.delegate = delegate;
        delegate.setMaximum(startMaximum);
    }

    @Override
    public void setMessage(String message) {
        this.delegate.setMessage(message);
    }

    @Override
    public void setProgress(long value) {
        this.delegate.setProgress(value);
        this.maybeUpdateMaximum();
    }

    @Override
    public void incrementProgress(long incrementAmount) {
        this.delegate.incrementProgress(incrementAmount);
        this.maybeUpdateMaximum();
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public void checkCanceled() throws CancelledException {
        this.delegate.checkCanceled();
    }

    private void maybeUpdateMaximum() {
        int _75_percent;
        long currentMaximum = this.delegate.getMaximum();
        long progress = this.delegate.getProgress();
        if (progress > (long)(_75_percent = (int)((double)currentMaximum * 0.75))) {
            this.delegate.setMaximum(currentMaximum + (currentMaximum - (long)_75_percent));
        }
    }
}

