/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.symbol;

import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyGrammar;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyTerminal;
import ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseNumericToken;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.collections4.MultiValuedMap;

public class AssemblyStringMapTerminal
extends AssemblyTerminal {
    protected final MultiValuedMap<String, Integer> map;

    public AssemblyStringMapTerminal(String name, MultiValuedMap<String, Integer> map) {
        super(name);
        this.map = map;
    }

    public Collection<AssemblyParseNumericToken> match(String buffer, int pos, AssemblyGrammar grammar, Map<String, Long> labels) {
        LinkedHashSet<AssemblyParseNumericToken> result = new LinkedHashSet<AssemblyParseNumericToken>();
        for (Map.Entry ent : this.map.entries()) {
            String str = (String)ent.getKey();
            if (!buffer.regionMatches(pos, str, 0, str.length())) continue;
            result.add(new AssemblyParseNumericToken(grammar, this, str, ((Integer)ent.getValue()).intValue()));
        }
        return result;
    }

    @Override
    public Collection<String> getSuggestions(String string, Map<String, Long> labels) {
        return this.map.keySet();
    }

    @Override
    public String toString() {
        return "[list:" + this.name + "]";
    }
}

