/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh;

import ghidra.app.plugin.processors.sleigh.ContextChange;
import ghidra.app.plugin.processors.sleigh.ContextCommit;
import ghidra.app.plugin.processors.sleigh.ContextOp;
import ghidra.app.plugin.processors.sleigh.FixedHandle;
import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighDebugLogger;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.symbol.OperandSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.SubtableSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.Symbol;
import ghidra.app.plugin.processors.sleigh.symbol.SymbolTable;
import ghidra.app.plugin.processors.sleigh.symbol.TripleSymbol;
import ghidra.app.plugin.processors.sleigh.template.ConstructTpl;
import ghidra.app.plugin.processors.sleigh.template.HandleTpl;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Constructor
implements Comparable<Constructor> {
    private SubtableSymbol parent = null;
    private OperandSymbol[] operands;
    private String[] separators;
    private String[] printpiece;
    private ContextChange[] context;
    private ConstructTpl templ = null;
    private ArrayList<ConstructTpl> namedtempl = null;
    private int minimumlength;
    private int id;
    private int firstwhitespace = -1;
    private int lineno;
    private int flowthruindex = -1;

    public String toString() {
        return "line" + this.lineno + "(id" + this.parent.getId() + "." + this.id + ")";
    }

    public List<String> getPrintPieces() {
        return Arrays.asList(this.printpiece);
    }

    public int getFlowthruIndex() {
        return this.flowthruindex;
    }

    public int getMinimumLength() {
        return this.minimumlength;
    }

    public void setId(int val) {
        this.id = val;
    }

    public int getId() {
        return this.id;
    }

    public int getLineno() {
        return this.lineno;
    }

    public SubtableSymbol getParent() {
        return this.parent;
    }

    public int getNumOperands() {
        return this.operands.length;
    }

    public OperandSymbol getOperand(int i) {
        return this.operands[i];
    }

    public ConstructTpl getTempl() {
        return this.templ;
    }

    public List<ContextChange> getContextChanges() {
        return Collections.unmodifiableList(Arrays.asList(this.context));
    }

    public String print(ParserWalker walker) throws MemoryAccessException {
        Object res = "";
        for (int i = 0; i < this.printpiece.length; ++i) {
            if (this.printpiece[i].length() == 0) continue;
            if (this.printpiece[i].charAt(0) == '\n') {
                int index = this.printpiece[i].charAt(1) - 65;
                res = (String)res + this.operands[index].print(walker);
                continue;
            }
            res = (String)res + this.printpiece[i];
        }
        return res;
    }

    public String printSeparator(int separatorIndex) {
        if (separatorIndex < 0 || separatorIndex > this.operands.length) {
            return null;
        }
        String cachedSeparator = this.separators[separatorIndex];
        if (cachedSeparator != null) {
            if (cachedSeparator.length() == 0) {
                return null;
            }
            return cachedSeparator;
        }
        for (int curPos = 0; curPos < this.printpiece.length && (this.printpiece[curPos].length() == 0 || this.printpiece[curPos].charAt(0) != ' '); ++curPos) {
        }
        int opIndex = 0;
        StringBuilder buf = new StringBuilder();
        for (int i = ++curPos; i < this.printpiece.length && opIndex <= separatorIndex; ++i) {
            if (this.printpiece[i].length() == 0) continue;
            if (this.printpiece[i].charAt(0) == '\n') {
                if (opIndex == separatorIndex) break;
                ++opIndex;
                continue;
            }
            if (opIndex != separatorIndex) continue;
            buf.append(this.printpiece[i]);
        }
        String separator = buf.toString();
        this.separators[separatorIndex] = separator = separator.replaceAll(",\\s+", ",");
        if (separator.length() == 0) {
            return null;
        }
        return separator;
    }

    public void printList(ParserWalker walker, ArrayList<Object> list) throws MemoryAccessException {
        HandleTpl res;
        int opSymbolCnt = 0;
        FixedHandle lastHandle = null;
        int lastHandleIndex = -1;
        block0: for (int i = 0; i < this.printpiece.length; ++i) {
            int prevSize = list.size();
            if (this.printpiece[i].length() == 0) continue;
            if (this.printpiece[i].charAt(0) == '\n') {
                int index = this.printpiece[i].charAt(1) - 65;
                this.operands[index].printList(walker, list);
                if (prevSize == list.size() || ++opSymbolCnt != 1) continue;
                for (int n = prevSize; n < list.size(); ++n) {
                    Object obj = list.get(n);
                    if (!(obj instanceof FixedHandle)) continue;
                    if (lastHandle != null) {
                        lastHandle = null;
                        continue block0;
                    }
                    lastHandle = (FixedHandle)obj;
                    lastHandleIndex = index;
                }
                continue;
            }
            for (int j = 0; j < this.printpiece[i].length(); ++j) {
                list.add(new Character(this.printpiece[i].charAt(j)));
            }
        }
        if (opSymbolCnt == 1 && lastHandle != null && lastHandle.fixable && this.templ != null && (res = this.templ.getResult()) != null) {
            res.fixPrintPiece(lastHandle, walker, lastHandleIndex);
        }
    }

    public String printMnemonic(ParserWalker walker) throws MemoryAccessException {
        TripleSymbol sym;
        Object res = "";
        if (this.flowthruindex != -1 && (sym = this.operands[this.flowthruindex].getDefiningSymbol()) instanceof SubtableSymbol) {
            walker.pushOperand(this.flowthruindex);
            res = walker.getConstructor().printMnemonic(walker);
            walker.popOperand();
            return res;
        }
        int endind = this.firstwhitespace == -1 ? this.printpiece.length : this.firstwhitespace;
        for (int i = 0; i < endind; ++i) {
            if (this.printpiece[i].length() == 0) continue;
            if (this.printpiece[i].charAt(0) == '\n') {
                int index = this.printpiece[i].charAt(1) - 65;
                res = (String)res + this.operands[index].print(walker);
                continue;
            }
            res = (String)res + this.printpiece[i];
        }
        return res;
    }

    public String printBody(ParserWalker walker) throws MemoryAccessException {
        TripleSymbol sym;
        Object res = "";
        if (this.flowthruindex != -1 && (sym = this.operands[this.flowthruindex].getDefiningSymbol()) instanceof SubtableSymbol) {
            walker.pushOperand(this.flowthruindex);
            res = walker.getConstructor().printBody(walker);
            walker.popOperand();
            return res;
        }
        if (this.firstwhitespace == -1) {
            return res;
        }
        for (int i = this.firstwhitespace + 1; i < this.printpiece.length; ++i) {
            if (this.printpiece[i].length() == 0) continue;
            if (this.printpiece[i].charAt(0) == '\n') {
                int index = this.printpiece[i].charAt(1) - 65;
                res = (String)res + this.operands[index].print(walker);
                continue;
            }
            res = (String)res + this.printpiece[i];
        }
        return res;
    }

    public void applyContext(ParserWalker walker, SleighDebugLogger debug) throws MemoryAccessException {
        for (int i = 0; i < this.context.length; ++i) {
            this.context[i].apply(walker, debug);
        }
    }

    public ConstructTpl getNamedTempl(int secnum) {
        if (this.namedtempl == null) {
            return null;
        }
        if (secnum < this.namedtempl.size()) {
            return this.namedtempl.get(secnum);
        }
        return null;
    }

    public void restoreXml(XmlPullParser parser, SleighLanguage sleigh) throws UnknownInstructionException {
        XmlElement el = parser.start(new String[]{"constructor"});
        SymbolTable symtab = sleigh.getSymbolTable();
        int myId = SpecXmlUtils.decodeInt((String)el.getAttribute("parent"));
        this.parent = (SubtableSymbol)symtab.findSymbol(myId);
        this.firstwhitespace = SpecXmlUtils.decodeInt((String)el.getAttribute("first"));
        this.minimumlength = SpecXmlUtils.decodeInt((String)el.getAttribute("length"));
        this.lineno = SpecXmlUtils.decodeInt((String)el.getAttribute("line"));
        ArrayList<Symbol> oplist = new ArrayList<Symbol>();
        ArrayList<Object> piecelist = new ArrayList<Object>();
        ArrayList<ContextChange> coplist = new ArrayList<ContextChange>();
        XmlElement subel = parser.peek();
        while (!subel.getName().equals("constructor")) {
            ContextChange c_op;
            if (subel.getName().equals("oper")) {
                myId = SpecXmlUtils.decodeInt((String)subel.getAttribute("id"));
                oplist.add(symtab.findSymbol(myId));
                parser.discardSubTree();
            } else if (subel.getName().equals("print")) {
                piecelist.add(subel.getAttribute("piece"));
                parser.discardSubTree();
            } else if (subel.getName().equals("opprint")) {
                myId = SpecXmlUtils.decodeInt((String)subel.getAttribute("id"));
                Object operstring = "\n";
                char ind = (char)(65 + myId);
                operstring = (String)operstring + ind;
                piecelist.add(operstring);
                parser.discardSubTree();
            } else if (subel.getName().equals("context_op")) {
                c_op = new ContextOp();
                ((ContextOp)c_op).restoreXml(parser, sleigh);
                coplist.add(c_op);
            } else if (subel.getName().equals("commit")) {
                c_op = new ContextCommit();
                ((ContextCommit)c_op).restoreXml(parser, sleigh);
                coplist.add(c_op);
            } else {
                ConstructTpl curtempl = new ConstructTpl();
                int sectionid = curtempl.restoreXml(parser, sleigh.getAddressFactory());
                if (sectionid < 0) {
                    if (this.templ != null) {
                        throw new UnknownInstructionException("Duplicate main template section");
                    }
                    this.templ = curtempl;
                } else {
                    if (this.namedtempl == null) {
                        this.namedtempl = new ArrayList();
                    }
                    while (this.namedtempl.size() <= sectionid) {
                        this.namedtempl.add(null);
                    }
                    if (this.namedtempl.get(sectionid) != null) {
                        throw new UnknownInstructionException("Duplicate named template section");
                    }
                    this.namedtempl.set(sectionid, curtempl);
                }
            }
            subel = parser.peek();
        }
        this.operands = new OperandSymbol[oplist.size()];
        this.separators = new String[this.operands.length + 1];
        oplist.toArray(this.operands);
        this.printpiece = new String[piecelist.size()];
        piecelist.toArray(this.printpiece);
        this.context = new ContextChange[coplist.size()];
        coplist.toArray(this.context);
        this.flowthruindex = this.printpiece.length == 1 && this.printpiece[0].length() >= 2 && this.printpiece[0].charAt(0) == '\n' ? this.printpiece[0].charAt(1) - 65 : -1;
        parser.end(el);
    }

    public int[] getOpsPrintOrder() {
        if (this.firstwhitespace == -1) {
            return new int[0];
        }
        int count = 0;
        for (int i = this.firstwhitespace + 1; i < this.printpiece.length; ++i) {
            if (this.printpiece[i].length() == 0 || this.printpiece[i].charAt(0) != '\n') continue;
            ++count;
        }
        int[] res = new int[count];
        count = 0;
        for (int i = this.firstwhitespace + 1; i < this.printpiece.length; ++i) {
            if (this.printpiece[i].length() == 0 || this.printpiece[i].charAt(0) != '\n') continue;
            res[count++] = this.printpiece[i].charAt(1) - 65;
        }
        return res;
    }

    @Override
    public int compareTo(Constructor that) {
        int result = this.id - that.id;
        if (result != 0) {
            return result;
        }
        result = this.parent.getId() - that.parent.getId();
        if (result != 0) {
            return result;
        }
        return 0;
    }

    public int hashCode() {
        return this.parent.getId() * 31 + this.id;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Constructor)) {
            return false;
        }
        Constructor that = (Constructor)obj;
        if (this.id != that.id) {
            return false;
        }
        return this.parent.getId() == that.parent.getId();
    }
}

