/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.mem;

import db.Record;
import ghidra.program.database.map.AddressMapDB;
import ghidra.program.database.mem.ByteSourceRange;
import ghidra.program.database.mem.ByteSourceRangeList;
import ghidra.program.database.mem.MemoryBlockDB;
import ghidra.program.database.mem.MemoryMapDB;
import ghidra.program.database.mem.MemoryMapDBAdapter;
import ghidra.program.database.mem.SubMemoryBlock;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockType;
import java.io.IOException;
import java.util.List;

class ByteMappedSubMemoryBlock
extends SubMemoryBlock {
    private final MemoryMapDB memMap;
    private final Address mappedAddress;
    private boolean ioPending;

    ByteMappedSubMemoryBlock(MemoryMapDBAdapter adapter, Record record) {
        super(adapter, record);
        this.memMap = adapter.getMemoryMap();
        AddressMapDB addressMap = this.memMap.getAddressMap();
        this.mappedAddress = addressMap.decodeAddress(record.getLongValue(5), false);
    }

    @Override
    public boolean isInitialized() {
        return false;
    }

    @Override
    public byte getByte(long offsetInMemBlock) throws MemoryAccessException, IOException {
        long offsetInSubBlock = offsetInMemBlock - this.subBlockOffset;
        if (this.ioPending) {
            new MemoryAccessException("Cyclic Access");
        }
        try {
            this.ioPending = true;
            byte by = this.memMap.getByte(this.mappedAddress.addNoWrap(offsetInSubBlock));
            return by;
        }
        catch (AddressOverflowException e) {
            throw new MemoryAccessException("No memory at address");
        }
        finally {
            this.ioPending = false;
        }
    }

    @Override
    public int getBytes(long offsetInMemBlock, byte[] b, int off, int len) throws MemoryAccessException, IOException {
        long offsetInSubBlock = offsetInMemBlock - this.subBlockOffset;
        long available = this.subBlockLength - offsetInSubBlock;
        len = (int)Math.min((long)len, available);
        if (this.ioPending) {
            new MemoryAccessException("Cyclic Access");
        }
        try {
            this.ioPending = true;
            int n = this.memMap.getBytes(this.mappedAddress.addNoWrap(offsetInSubBlock), b, off, len);
            return n;
        }
        catch (AddressOverflowException e) {
            throw new MemoryAccessException("No memory at address");
        }
        finally {
            this.ioPending = false;
        }
    }

    @Override
    public void putByte(long offsetInMemBlock, byte b) throws MemoryAccessException, IOException {
        long offsetInSubBlock = offsetInMemBlock - this.subBlockOffset;
        try {
            if (this.ioPending) {
                new MemoryAccessException("Cyclic Access");
            }
            this.ioPending = true;
            this.memMap.setByte(this.mappedAddress.addNoWrap(offsetInSubBlock), b);
        }
        catch (AddressOverflowException e) {
            throw new MemoryAccessException("No memory at address");
        }
        finally {
            this.ioPending = false;
        }
    }

    @Override
    public int putBytes(long offsetInMemBlock, byte[] b, int off, int len) throws MemoryAccessException, IOException {
        long offsetInSubBlock = offsetInMemBlock - this.subBlockOffset;
        long available = this.subBlockLength - offsetInSubBlock;
        len = (int)Math.min((long)len, available);
        try {
            if (this.ioPending) {
                new MemoryAccessException("Cyclic Access");
            }
            this.ioPending = true;
            this.memMap.setBytes(this.mappedAddress.addNoWrap(offsetInSubBlock), b, off, len);
            int n = len;
            return n;
        }
        catch (AddressOverflowException e) {
            throw new MemoryAccessException("No memory at address");
        }
        finally {
            this.ioPending = false;
        }
    }

    public AddressRange getMappedRange() {
        Address endMappedAddress = this.mappedAddress.add(this.subBlockLength - 1L);
        return new AddressRangeImpl(this.mappedAddress, endMappedAddress);
    }

    @Override
    protected boolean join(SubMemoryBlock sub2) {
        return false;
    }

    @Override
    protected boolean isMapped() {
        return true;
    }

    @Override
    protected MemoryBlockType getType() {
        return MemoryBlockType.BYTE_MAPPED;
    }

    @Override
    protected SubMemoryBlock split(long memBlockOffset) throws IOException {
        int offset = (int)(memBlockOffset - this.subBlockOffset);
        long newLength = this.subBlockLength - (long)offset;
        this.subBlockLength = offset;
        this.record.setLongValue(2, this.subBlockLength);
        this.adapter.updateSubBlockRecord(this.record);
        Address newAddr = this.mappedAddress.add(offset);
        AddressMapDB addressMap = this.adapter.getMemoryMap().getAddressMap();
        long encodedAddr = addressMap.getKey(newAddr, true);
        Record newSubRecord = this.adapter.createSubBlockRecord(0L, 0L, newLength, (byte)1, 0, encodedAddr);
        return new ByteMappedSubMemoryBlock(this.adapter, newSubRecord);
    }

    @Override
    protected String getDescription() {
        return "Byte Mapped: " + this.mappedAddress;
    }

    @Override
    protected ByteSourceRangeList getByteSourceRangeList(MemoryBlock block, Address start, long offset, long size) {
        ByteSourceRangeList result = new ByteSourceRangeList();
        long relativeOffset = offset - this.subBlockOffset;
        Address startAddress = this.mappedAddress.add(relativeOffset);
        Address endAddress = startAddress.add(size - 1L);
        List<MemoryBlockDB> blocks = this.memMap.getBlocks(startAddress, endAddress);
        for (MemoryBlockDB mappedBlock : blocks) {
            Address startInBlock = this.max(mappedBlock.getStart(), startAddress);
            Address endInBlock = this.min(mappedBlock.getEnd(), endAddress);
            AddressRangeImpl blockRange = new AddressRangeImpl(startInBlock, endInBlock);
            ByteSourceRangeList ranges = mappedBlock.getByteSourceRangeList(startInBlock, blockRange.getLength());
            for (ByteSourceRange bsRange : ranges) {
                result.add(this.translate(block, bsRange, start, relativeOffset));
            }
        }
        return result;
    }

    private ByteSourceRange translate(MemoryBlock block, ByteSourceRange bsRange, Address addr, long relativeOffset) {
        Address mappedStart = bsRange.getStart();
        long offset = mappedStart.subtract(this.mappedAddress);
        Address start = addr.add(offset - relativeOffset);
        return new ByteSourceRange(block, start, bsRange.getSize(), bsRange.getSourceId(), bsRange.getOffset());
    }

    Address min(Address a1, Address a2) {
        return a1.compareTo(a2) <= 0 ? a1 : a2;
    }

    Address max(Address a1, Address a2) {
        return a1.compareTo(a2) >= 0 ? a1 : a2;
    }
}

