/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.register;

import ghidra.program.database.register.RegisterValueRange;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import java.util.Iterator;

class SimpleAddressRangeIterator
implements AddressRangeIterator {
    int pos = 0;
    RegisterValueRange[] valueRanges;

    public SimpleAddressRangeIterator(RegisterValueRange[] valueRanges) {
        this.valueRanges = valueRanges == null ? new RegisterValueRange[]{} : valueRanges;
    }

    @Override
    public Iterator<AddressRange> iterator() {
        return this;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.valueRanges.length;
    }

    @Override
    public AddressRange next() {
        RegisterValueRange valueRange = this.valueRanges[this.pos++];
        return new AddressRangeImpl(valueRange.getStartAddress(), valueRange.getEndAddress());
    }
}

