/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.EnumSettingsDefinition;
import ghidra.docking.settings.Settings;

public class MutabilitySettingsDefinition
implements EnumSettingsDefinition {
    public static final int NORMAL = 0;
    public static final int VOLATILE = 1;
    public static final int CONSTANT = 2;
    private static final String[] choices = new String[]{"normal", "volatile", "constant"};
    public static final String MUTABILITY = "mutability";
    public static final MutabilitySettingsDefinition DEF = new MutabilitySettingsDefinition();

    private MutabilitySettingsDefinition() {
    }

    public int getMutabilityMode(Settings settings) {
        if (settings == null) {
            return 0;
        }
        Long value = settings.getLong(MUTABILITY);
        if (value == null) {
            return 0;
        }
        int mode = (int)value.longValue();
        if (mode < 0 || mode > 2) {
            mode = 0;
        }
        return mode;
    }

    public int getChoice(Settings settings) {
        return this.getMutabilityMode(settings);
    }

    public void setChoice(Settings settings, int value) {
        if (value < 0 || value > 2) {
            settings.clearSetting(MUTABILITY);
        } else {
            settings.setLong(MUTABILITY, (long)value);
        }
    }

    public String[] getDisplayChoices(Settings settings) {
        return choices;
    }

    public String getName() {
        return "Mutability";
    }

    public String getDescription() {
        return "Selects the data mutability";
    }

    public String getDisplayChoice(int value, Settings s1) {
        return choices[value];
    }

    public void clear(Settings settings) {
        settings.clearSetting(MUTABILITY);
    }

    public void copySetting(Settings settings, Settings destSettings) {
        Long l = settings.getLong(MUTABILITY);
        if (l == null) {
            destSettings.clearSetting(MUTABILITY);
        } else {
            destSettings.setLong(MUTABILITY, l.longValue());
        }
    }

    public boolean hasValue(Settings setting) {
        return setting.getValue(MUTABILITY) != null;
    }
}

