/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.db;

import ghidra.feature.fid.db.FidDB;
import ghidra.feature.fid.db.FidFileManager;
import ghidra.feature.fid.db.LibraryRecord;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageDescription;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.util.DefaultLanguageService;
import ghidra.util.Msg;
import ghidra.util.exception.VersionException;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.FilenameUtils;

public class FidFile
implements Comparable<FidFile> {
    public static final String FID_PACKED_DATABASE_FILE_EXTENSION = ".fidb";
    public static final String FID_RAW_DATABASE_FILE_EXTENSION = ".fidbf";
    private final File file;
    private final boolean isInstalled;
    private boolean isActive = true;
    private FidFileManager fidFileManager;
    private Set<LanguageDescription> supportedLanguages;
    private FidDB openUpdateableFidDB;

    FidFile(FidFileManager fidFileManager, File file, boolean isInstalled) {
        this.fidFileManager = fidFileManager;
        this.file = file;
        this.isInstalled = isInstalled;
    }

    boolean isValidFile() {
        FidDB fidDB = this.getFidDB(false);
        try {
            boolean bl = true;
            if (fidDB != null) {
                fidDB.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (fidDB != null) {
                    try {
                        fidDB.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (VersionException e) {
                Msg.showError((Object)this, null, (String)"Failed to open FidDb", (Object)("Failed to open incompatible FidDb (may need to regenerate with this version of Ghidra): " + this.file.getAbsolutePath()));
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)("Failed to open FidDb: " + this.file.getAbsolutePath()), (Throwable)e);
            }
        }
        return false;
    }

    public void setActive(boolean b) {
        this.isActive = b;
        this.fidFileManager.activeStateChanged(this);
    }

    public synchronized FidDB getFidDB(boolean openForUpdate) throws VersionException, IOException {
        if (openForUpdate && this.openUpdateableFidDB != null) {
            this.openUpdateableFidDB.incrementOpenCount();
            return this.openUpdateableFidDB;
        }
        FidDB fidDB = new FidDB(this, openForUpdate);
        if (openForUpdate) {
            this.openUpdateableFidDB = fidDB;
        }
        return fidDB;
    }

    File getFile() {
        return this.file;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isInstalled() {
        return this.isInstalled;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FidFile other = (FidFile)obj;
        return this.file.equals(other.file);
    }

    public String getPath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public int compareTo(FidFile o) {
        return this.file.compareTo(o.file);
    }

    public String getName() {
        return this.file.getName();
    }

    public String getBaseName() {
        return FilenameUtils.removeExtension((String)this.file.getName());
    }

    public boolean canProcessLanguage(Language language) {
        if (this.supportedLanguages == null) {
            this.supportedLanguages = this.getSupportedLanguages();
        }
        return this.supportedLanguages.contains(language.getLanguageDescription());
    }

    private Set<LanguageDescription> getSupportedLanguages() {
        TreeSet<LanguageDescription> languages = new TreeSet<LanguageDescription>(new ProcessorSizeComparator());
        LanguageService languageService = DefaultLanguageService.getLanguageService();
        try (FidDB fidDB = this.getFidDB(false);){
            List<LibraryRecord> allLibraries = fidDB.getAllLibraries();
            for (LibraryRecord libraryRecord : allLibraries) {
                LanguageID ghidraLanguageID = libraryRecord.getGhidraLanguageID();
                LanguageDescription languageDescription = languageService.getLanguageDescription(ghidraLanguageID);
                languages.add(languageDescription);
            }
        }
        catch (VersionException e) {
            Msg.error((Object)this, (Object)("Failed to open incompatible FidDb (may need to regenerate with this version of Ghidra): " + this.file.getAbsolutePath()));
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Failed to open FidDb: " + this.file.getAbsolutePath()), (Throwable)e);
        }
        return languages;
    }

    void closingFidDB(FidDB fidDB) {
        if (fidDB == this.openUpdateableFidDB) {
            this.openUpdateableFidDB = null;
        }
    }

    private static class ProcessorSizeComparator
    implements Comparator<LanguageDescription> {
        private ProcessorSizeComparator() {
        }

        @Override
        public int compare(LanguageDescription o1, LanguageDescription o2) {
            int res = o1.getProcessor().compareTo(o2.getProcessor());
            if (res != 0) {
                return res;
            }
            if (o1.getSize() != o2.getSize()) {
                return o1.getSize() < o2.getSize() ? -1 : 1;
            }
            if (o1.getInstructionEndian() != o2.getInstructionEndian()) {
                return o1.getInstructionEndian().isBigEndian() ? -1 : 1;
            }
            return 0;
        }
    }
}

