/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.job;

import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import ghidra.graph.job.AbstractAnimatorJob;
import java.awt.geom.Point2D;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.interpolation.PropertySetter;

public abstract class MoveViewAnimatorFunctionGraphJob<V, E>
extends AbstractAnimatorJob {
    private static final int PIXELS_PER_SECOND = 750;
    private static final int FRAME_PER_SECOND = 10;
    private final Point2D lastPoint = new Point2D.Double();
    private int totalFrames;
    protected final VisualizationViewer<V, E> viewer;
    private MultiLayerTransformer multiLayerTransformer;
    private final boolean useAnimation;
    private Point2D destination;

    public MoveViewAnimatorFunctionGraphJob(VisualizationServer<V, E> viewer, boolean useAnimation) {
        if (!(viewer instanceof VisualizationViewer)) {
            throw new IllegalArgumentException("VisualizationServer is not an instance of VisualizationViewer.  We currently need this for bounds information.");
        }
        this.viewer = (VisualizationViewer)viewer;
        this.useAnimation = useAnimation;
    }

    protected abstract Point2D createDestination();

    @Override
    protected Animator createAnimator() {
        this.destination = this.createDestination();
        RenderContext renderContext = this.viewer.getRenderContext();
        this.multiLayerTransformer = renderContext.getMultiLayerTransformer();
        if (!this.useAnimation) {
            return null;
        }
        double offsetX = this.destination.getX();
        double offsetY = this.destination.getY();
        double durationX = Math.abs(offsetX / 750.0);
        double durationY = Math.abs(offsetY / 750.0);
        int totalFramesX = (int)(durationX * 10.0);
        int totalFramesY = (int)(durationY * 10.0);
        int mostFrames = Math.max(totalFramesX, totalFramesY);
        mostFrames = Math.min(mostFrames, 15);
        this.totalFrames = Math.max(1, mostFrames);
        double timeInSeconds = (double)this.totalFrames / 10.0;
        int duration = (int)Math.round(timeInSeconds * 1000.0);
        Point2D.Double start = new Point2D.Double();
        Animator newAnimator = PropertySetter.createAnimator((int)duration, (Object)this, (String)"offset", (Object[])new Point2D[]{start, this.destination});
        newAnimator.setAcceleration(0.2f);
        newAnimator.setDeceleration(0.8f);
        return newAnimator;
    }

    @Override
    protected void finished() {
        if (this.isShortcut) {
            this.destination = this.createDestination();
        }
        this.setOffset(this.destination);
    }

    public void setOffset(Point2D offsetFromOriginalPoint) {
        double newX = offsetFromOriginalPoint.getX();
        double newY = offsetFromOriginalPoint.getY();
        double deltaX = newX - this.lastPoint.getX();
        double deltaY = newY - this.lastPoint.getY();
        this.lastPoint.setLocation(newX, newY);
        if (deltaX == 0.0 && deltaY == 0.0) {
            return;
        }
        this.multiLayerTransformer.getTransformer(Layer.LAYOUT).translate(deltaX, deltaY);
        this.viewer.repaint();
    }
}

