/*
 * Decompiled with CFR 0.152.
 */
package sun.util.calendar;

public class CalendarUtils {
    public static final boolean isGregorianLeapYear(int n) {
        return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    public static final boolean isJulianLeapYear(int n) {
        return n % 4 == 0;
    }

    public static final long floorDivide(long l, long l2) {
        return l >= 0L ? l / l2 : (l + 1L) / l2 - 1L;
    }

    public static final int floorDivide(int n, int n2) {
        return n >= 0 ? n / n2 : (n + 1) / n2 - 1;
    }

    public static final int floorDivide(int n, int n2, int[] nArray) {
        if (n >= 0) {
            nArray[0] = n % n2;
            return n / n2;
        }
        int n3 = (n + 1) / n2 - 1;
        nArray[0] = n - n3 * n2;
        return n3;
    }

    public static final int floorDivide(long l, int n, int[] nArray) {
        if (l >= 0L) {
            nArray[0] = (int)(l % (long)n);
            return (int)(l / (long)n);
        }
        int n2 = (int)((l + 1L) / (long)n - 1L);
        nArray[0] = (int)(l - (long)(n2 * n));
        return n2;
    }

    public static final long mod(long l, long l2) {
        return l - l2 * CalendarUtils.floorDivide(l, l2);
    }

    public static final int mod(int n, int n2) {
        return n - n2 * CalendarUtils.floorDivide(n, n2);
    }

    public static final int amod(int n, int n2) {
        int n3 = CalendarUtils.mod(n, n2);
        return n3 == 0 ? n2 : n3;
    }

    public static final long amod(long l, long l2) {
        long l3 = CalendarUtils.mod(l, l2);
        return l3 == 0L ? l2 : l3;
    }

    public static final StringBuilder sprintf0d(StringBuilder stringBuilder, int n, int n2) {
        int n3;
        long l = n;
        if (l < 0L) {
            stringBuilder.append('-');
            l = -l;
            --n2;
        }
        int n4 = 10;
        for (n3 = 2; n3 < n2; ++n3) {
            n4 *= 10;
        }
        for (n3 = 1; n3 < n2 && l < (long)n4; ++n3) {
            stringBuilder.append('0');
            n4 /= 10;
        }
        stringBuilder.append(l);
        return stringBuilder;
    }

    public static final StringBuffer sprintf0d(StringBuffer stringBuffer, int n, int n2) {
        int n3;
        long l = n;
        if (l < 0L) {
            stringBuffer.append('-');
            l = -l;
            --n2;
        }
        int n4 = 10;
        for (n3 = 2; n3 < n2; ++n3) {
            n4 *= 10;
        }
        for (n3 = 1; n3 < n2 && l < (long)n4; ++n3) {
            stringBuffer.append('0');
            n4 /= 10;
        }
        stringBuffer.append(l);
        return stringBuffer;
    }
}

