/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkCommandBufferInheritanceInfo;

public class VkCommandBufferBeginInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int PINHERITANCEINFO;

    public VkCommandBufferBeginInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkCommandBufferBeginInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCommandBufferBeginInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCommandBufferBeginInfo.npNext(this.address());
    }

    @NativeType(value="VkCommandBufferUsageFlags")
    public int flags() {
        return VkCommandBufferBeginInfo.nflags(this.address());
    }

    @Nullable
    @NativeType(value="VkCommandBufferInheritanceInfo const *")
    public VkCommandBufferInheritanceInfo pInheritanceInfo() {
        return VkCommandBufferBeginInfo.npInheritanceInfo(this.address());
    }

    public VkCommandBufferBeginInfo sType(@NativeType(value="VkStructureType") int value) {
        VkCommandBufferBeginInfo.nsType(this.address(), value);
        return this;
    }

    public VkCommandBufferBeginInfo pNext(@NativeType(value="void const *") long value) {
        VkCommandBufferBeginInfo.npNext(this.address(), value);
        return this;
    }

    public VkCommandBufferBeginInfo flags(@NativeType(value="VkCommandBufferUsageFlags") int value) {
        VkCommandBufferBeginInfo.nflags(this.address(), value);
        return this;
    }

    public VkCommandBufferBeginInfo pInheritanceInfo(@Nullable @NativeType(value="VkCommandBufferInheritanceInfo const *") VkCommandBufferInheritanceInfo value) {
        VkCommandBufferBeginInfo.npInheritanceInfo(this.address(), value);
        return this;
    }

    public VkCommandBufferBeginInfo set(int sType, long pNext, int flags, @Nullable VkCommandBufferInheritanceInfo pInheritanceInfo) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pInheritanceInfo(pInheritanceInfo);
        return this;
    }

    public VkCommandBufferBeginInfo set(VkCommandBufferBeginInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkCommandBufferBeginInfo malloc() {
        return (VkCommandBufferBeginInfo)VkCommandBufferBeginInfo.wrap(VkCommandBufferBeginInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkCommandBufferBeginInfo calloc() {
        return (VkCommandBufferBeginInfo)VkCommandBufferBeginInfo.wrap(VkCommandBufferBeginInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkCommandBufferBeginInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkCommandBufferBeginInfo)VkCommandBufferBeginInfo.wrap(VkCommandBufferBeginInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkCommandBufferBeginInfo create(long address) {
        return (VkCommandBufferBeginInfo)VkCommandBufferBeginInfo.wrap(VkCommandBufferBeginInfo.class, (long)address);
    }

    @Nullable
    public static VkCommandBufferBeginInfo createSafe(long address) {
        return address == 0L ? null : (VkCommandBufferBeginInfo)VkCommandBufferBeginInfo.wrap(VkCommandBufferBeginInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkCommandBufferBeginInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkCommandBufferBeginInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkCommandBufferBeginInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCommandBufferBeginInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkCommandBufferBeginInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkCommandBufferBeginInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkCommandBufferBeginInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkCommandBufferBeginInfo mallocStack() {
        return VkCommandBufferBeginInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkCommandBufferBeginInfo callocStack() {
        return VkCommandBufferBeginInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkCommandBufferBeginInfo mallocStack(MemoryStack stack) {
        return (VkCommandBufferBeginInfo)VkCommandBufferBeginInfo.wrap(VkCommandBufferBeginInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkCommandBufferBeginInfo callocStack(MemoryStack stack) {
        return (VkCommandBufferBeginInfo)VkCommandBufferBeginInfo.wrap(VkCommandBufferBeginInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkCommandBufferBeginInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkCommandBufferBeginInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkCommandBufferBeginInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkCommandBufferBeginInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    @Nullable
    public static VkCommandBufferInheritanceInfo npInheritanceInfo(long struct) {
        return VkCommandBufferInheritanceInfo.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PINHERITANCEINFO)));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void npInheritanceInfo(long struct, @Nullable VkCommandBufferInheritanceInfo value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PINHERITANCEINFO), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    static {
        Struct.Layout layout = VkCommandBufferBeginInfo.__struct((Struct.Member[])new Struct.Member[]{VkCommandBufferBeginInfo.__member((int)4), VkCommandBufferBeginInfo.__member((int)POINTER_SIZE), VkCommandBufferBeginInfo.__member((int)4), VkCommandBufferBeginInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        PINHERITANCEINFO = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkCommandBufferBeginInfo, Buffer>
    implements NativeResource {
        private static final VkCommandBufferBeginInfo ELEMENT_FACTORY = VkCommandBufferBeginInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkCommandBufferBeginInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCommandBufferBeginInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCommandBufferBeginInfo.npNext(this.address());
        }

        @NativeType(value="VkCommandBufferUsageFlags")
        public int flags() {
            return VkCommandBufferBeginInfo.nflags(this.address());
        }

        @Nullable
        @NativeType(value="VkCommandBufferInheritanceInfo const *")
        public VkCommandBufferInheritanceInfo pInheritanceInfo() {
            return VkCommandBufferBeginInfo.npInheritanceInfo(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCommandBufferBeginInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCommandBufferBeginInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkCommandBufferUsageFlags") int value) {
            VkCommandBufferBeginInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer pInheritanceInfo(@Nullable @NativeType(value="VkCommandBufferInheritanceInfo const *") VkCommandBufferInheritanceInfo value) {
            VkCommandBufferBeginInfo.npInheritanceInfo(this.address(), value);
            return this;
        }
    }
}

