/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.xxhash;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct XXH64_canonical_t")
public class XXH64Canonical
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DIGEST;

    public XXH64Canonical(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XXH64Canonical.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned char[8]")
    public ByteBuffer digest() {
        return XXH64Canonical.ndigest(this.address());
    }

    @NativeType(value="unsigned char")
    public byte digest(int index) {
        return XXH64Canonical.ndigest(this.address(), index);
    }

    public static XXH64Canonical malloc() {
        return (XXH64Canonical)XXH64Canonical.wrap(XXH64Canonical.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XXH64Canonical calloc() {
        return (XXH64Canonical)XXH64Canonical.wrap(XXH64Canonical.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XXH64Canonical create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XXH64Canonical)XXH64Canonical.wrap(XXH64Canonical.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XXH64Canonical create(long address) {
        return (XXH64Canonical)XXH64Canonical.wrap(XXH64Canonical.class, (long)address);
    }

    @Nullable
    public static XXH64Canonical createSafe(long address) {
        return address == 0L ? null : (XXH64Canonical)XXH64Canonical.wrap(XXH64Canonical.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XXH64Canonical.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XXH64Canonical.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XXH64Canonical.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XXH64Canonical.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XXH64Canonical.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XXH64Canonical.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XXH64Canonical.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XXH64Canonical mallocStack() {
        return XXH64Canonical.mallocStack(MemoryStack.stackGet());
    }

    public static XXH64Canonical callocStack() {
        return XXH64Canonical.callocStack(MemoryStack.stackGet());
    }

    public static XXH64Canonical mallocStack(MemoryStack stack) {
        return (XXH64Canonical)XXH64Canonical.wrap(XXH64Canonical.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XXH64Canonical callocStack(MemoryStack stack) {
        return (XXH64Canonical)XXH64Canonical.wrap(XXH64Canonical.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return XXH64Canonical.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return XXH64Canonical.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)XXH64Canonical.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)XXH64Canonical.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static ByteBuffer ndigest(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DIGEST), (int)8);
    }

    public static byte ndigest(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)DIGEST + Checks.check((int)index, (int)8) * 1L);
    }

    static {
        Struct.Layout layout = XXH64Canonical.__struct((Struct.Member[])new Struct.Member[]{XXH64Canonical.__array((int)1, (int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DIGEST = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<XXH64Canonical, Buffer>
    implements NativeResource {
        private static final XXH64Canonical ELEMENT_FACTORY = XXH64Canonical.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XXH64Canonical getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned char[8]")
        public ByteBuffer digest() {
            return XXH64Canonical.ndigest(this.address());
        }

        @NativeType(value="unsigned char")
        public byte digest(int index) {
            return XXH64Canonical.ndigest(this.address(), index);
        }
    }
}

