/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.compiler;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.function.Consumer;
import org.openide.util.BaseUtilities;
import org.openide.util.RequestProcessor;

final class TimedSoftReference<T>
extends SoftReference<T>
implements Runnable {
    private static final int TIMEOUT = 30000;
    private static final RequestProcessor RP = new RequestProcessor("TimedSoftReference");
    private RequestProcessor.Task task;
    private T o;
    private final Consumer<Reference<T>> removeFunc;
    private long touched;

    TimedSoftReference(T o, Consumer<Reference<T>> removeFunc) {
        super(o, BaseUtilities.activeReferenceQueue());
        this.o = o;
        this.removeFunc = removeFunc;
        try {
            this.task = RP.create((Runnable)this);
            this.task.schedule(30000);
        }
        catch (SecurityException ex) {
            this.o = null;
            this.task = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TimedSoftReference timedSoftReference = this;
        synchronized (timedSoftReference) {
            if (this.o != null) {
                long unused = System.currentTimeMillis() - this.touched;
                if (unused > 15000L) {
                    this.o = null;
                    this.touched = 0L;
                } else {
                    this.task.schedule(30000 - (int)unused);
                }
                return;
            }
        }
        this.removeFunc.accept(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        TimedSoftReference timedSoftReference = this;
        synchronized (timedSoftReference) {
            if (this.o == null) {
                this.o = super.get();
            }
            if (this.o != null) {
                if (this.touched == 0L && this.task != null) {
                    this.task.schedule(30000);
                }
                this.touched = System.currentTimeMillis();
                return this.o;
            }
            return null;
        }
    }
}

