/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.loaders;

import java.io.File;
import java.util.logging.Logger;
import org.netbeans.modules.gradle.GradleProject;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.api.NbProjectInfo;
import org.netbeans.modules.gradle.cache.SubProjectDiskCache;
import org.netbeans.modules.gradle.loaders.AbstractProjectLoader;
import org.netbeans.modules.gradle.loaders.ModelCache;
import org.netbeans.modules.gradle.loaders.ModelCacheManager;
import org.netbeans.modules.gradle.loaders.NbProjectInfoCachingDescriptor;
import org.netbeans.modules.gradle.loaders.ProjectStructureCachingDescriptor;
import org.netbeans.modules.gradle.options.GradleExperimentalSettings;
import org.openide.util.Exceptions;

public class BundleProjectLoader
extends AbstractProjectLoader {
    private static final Logger LOGGER = Logger.getLogger(BundleProjectLoader.class.getName());

    BundleProjectLoader(AbstractProjectLoader.ReloadContext ctx) {
        super(ctx);
    }

    @Override
    GradleProject load() {
        File rootDir = this.ctx.project.getGradleFiles().getRootDir();
        SubProjectDiskCache spCache = SubProjectDiskCache.get(rootDir);
        if (!spCache.isValid()) {
            ModelCache<org.gradle.tooling.model.GradleProject> modelCache = ModelCacheManager.getModelCache(rootDir, org.gradle.tooling.model.GradleProject.class, () -> new ModelCache<org.gradle.tooling.model.GradleProject>(this.ctx.project, new ProjectStructureCachingDescriptor(rootDir)));
            try {
                modelCache.refreshAndWait();
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (spCache.isValid()) {
            SubProjectDiskCache.SubProjectInfo structure = (SubProjectDiskCache.SubProjectInfo)spCache.loadData();
            ModelCache<NbProjectInfo> modelCache = ModelCacheManager.getModelCache(rootDir, NbProjectInfo.class, () -> new ModelCache<NbProjectInfo>(this.ctx.project, new NbProjectInfoCachingDescriptor(structure)));
            try {
                modelCache.refreshAndWait();
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    @Override
    boolean isEnabled() {
        return this.ctx.getAim().betterThan(NbGradleProject.Quality.FALLBACK) && GradleExperimentalSettings.getDefault().isBundledLoading();
    }
}

