/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTaskMirror;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.util.KeepAliveOutputStream;

public class FormatterElement {
    public static final String XML_FORMATTER_CLASS_NAME = "org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter";
    public static final String BRIEF_FORMATTER_CLASS_NAME = "org.apache.tools.ant.taskdefs.optional.junit.BriefJUnitResultFormatter";
    public static final String PLAIN_FORMATTER_CLASS_NAME = "org.apache.tools.ant.taskdefs.optional.junit.PlainJUnitResultFormatter";
    public static final String FAILURE_RECORDER_CLASS_NAME = "org.apache.tools.ant.taskdefs.optional.junit.FailureRecorder";
    private String classname;
    private String extension;
    private OutputStream out = new KeepAliveOutputStream((OutputStream)System.out);
    private File outFile;
    private boolean useFile = true;
    private Object ifCond;
    private Object unlessCond;
    private Project project;

    public void setType(TypeAttribute type) {
        switch (type.getValue()) {
            case "xml": {
                this.setClassname(XML_FORMATTER_CLASS_NAME);
                break;
            }
            case "brief": {
                this.setClassname(BRIEF_FORMATTER_CLASS_NAME);
                break;
            }
            case "failure": {
                this.setClassname(FAILURE_RECORDER_CLASS_NAME);
                break;
            }
            default: {
                this.setClassname(PLAIN_FORMATTER_CLASS_NAME);
            }
        }
    }

    public void setClassname(String classname) {
        this.classname = classname;
        if (classname != null) {
            switch (classname) {
                case "org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter": {
                    this.setExtension(".xml");
                    break;
                }
                case "org.apache.tools.ant.taskdefs.optional.junit.PlainJUnitResultFormatter": {
                    this.setExtension(".txt");
                    break;
                }
                case "org.apache.tools.ant.taskdefs.optional.junit.BriefJUnitResultFormatter": {
                    this.setExtension(".txt");
                }
            }
        }
    }

    public String getClassname() {
        return this.classname;
    }

    public void setExtension(String ext) {
        this.extension = ext;
    }

    public String getExtension() {
        return this.extension;
    }

    void setOutfile(File out) {
        this.outFile = out;
    }

    public void setOutput(OutputStream out) {
        if (out == System.out || out == System.err) {
            out = new KeepAliveOutputStream(out);
        }
        this.out = out;
    }

    public void setUseFile(boolean useFile) {
        this.useFile = useFile;
    }

    boolean getUseFile() {
        return this.useFile;
    }

    public void setIf(Object ifCond) {
        this.ifCond = ifCond;
    }

    public void setIf(String ifCond) {
        this.setIf((Object)ifCond);
    }

    public void setUnless(Object unlessCond) {
        this.unlessCond = unlessCond;
    }

    public void setUnless(String unlessCond) {
        this.setUnless((Object)unlessCond);
    }

    public boolean shouldUse(Task t) {
        PropertyHelper ph = PropertyHelper.getPropertyHelper((Project)t.getProject());
        return ph.testIfCondition(this.ifCond) && ph.testUnlessCondition(this.unlessCond);
    }

    JUnitTaskMirror.JUnitResultFormatterMirror createFormatter() throws BuildException {
        return this.createFormatter(null);
    }

    public void setProject(Project project) {
        this.project = project;
    }

    JUnitTaskMirror.JUnitResultFormatterMirror createFormatter(ClassLoader loader) throws BuildException {
        JUnitTaskMirror.JUnitResultFormatterMirror r;
        Class<?> f;
        if (this.classname == null) {
            throw new BuildException("you must specify type or classname");
        }
        try {
            f = loader == null ? Class.forName(this.classname) : Class.forName(this.classname, true, loader);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new BuildException("Using loader " + loader + " on class " + this.classname + ": " + e, e);
        }
        try {
            r = f.asSubclass(JUnitTaskMirror.JUnitResultFormatterMirror.class).newInstance();
        }
        catch (ClassCastException e) {
            throw new BuildException("%s is not a JUnitResultFormatter", new Object[]{this.classname});
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new BuildException((Throwable)e);
        }
        if (this.useFile && this.outFile != null) {
            this.out = new DelayedFileOutputStream(this.outFile);
        }
        r.setOutput(this.out);
        boolean needToSetProjectReference = true;
        try {
            Field field = r.getClass().getField("project");
            Object value = field.get(r);
            if (value instanceof Project) {
                needToSetProjectReference = false;
            }
        }
        catch (NoSuchFieldException field) {
        }
        catch (IllegalAccessException e) {
            throw new BuildException((Throwable)e);
        }
        if (needToSetProjectReference) {
            try {
                Method setter = r.getClass().getMethod("setProject", Project.class);
                setter.invoke((Object)r, this.project);
            }
            catch (NoSuchMethodException value) {
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new BuildException((Throwable)e);
            }
        }
        return r;
    }

    public static class TypeAttribute
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"plain", "xml", "brief", "failure"};
        }
    }

    private static class DelayedFileOutputStream
    extends OutputStream {
        private BufferedOutputStream outputStream;
        private final File file;

        public DelayedFileOutputStream(File file) {
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            DelayedFileOutputStream delayedFileOutputStream = this;
            synchronized (delayedFileOutputStream) {
                if (this.outputStream == null) {
                    this.outputStream = new BufferedOutputStream(Files.newOutputStream(this.file.toPath(), new OpenOption[0]));
                }
            }
            this.outputStream.write(b);
        }

        @Override
        public void flush() throws IOException {
            if (this.outputStream != null) {
                this.outputStream.flush();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
    }
}

