/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.Statement;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;

public final class ThrowNode
extends Statement {
    private final Expression expression;
    private final boolean isSyntheticRethrow;

    public ThrowNode(int n, long l, int n2, Expression expression, boolean bl) {
        super(n, l, n2);
        this.expression = expression;
        this.isSyntheticRethrow = bl;
    }

    private ThrowNode(ThrowNode throwNode, Expression expression, boolean bl) {
        super(throwNode);
        this.expression = expression;
        this.isSyntheticRethrow = bl;
    }

    @Override
    public boolean isTerminal() {
        return true;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> nodeVisitor) {
        if (nodeVisitor.enterThrowNode(this)) {
            return nodeVisitor.leaveThrowNode(this.setExpression((Expression)this.expression.accept(nodeVisitor)));
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> translatorNodeVisitor) {
        return translatorNodeVisitor.enterThrowNode(this);
    }

    @Override
    public void toString(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("throw ");
        if (this.expression != null) {
            this.expression.toString(stringBuilder, bl);
        }
    }

    public Expression getExpression() {
        return this.expression;
    }

    public ThrowNode setExpression(Expression expression) {
        if (this.expression == expression) {
            return this;
        }
        return new ThrowNode(this, expression, this.isSyntheticRethrow);
    }

    public boolean isSyntheticRethrow() {
        return this.isSyntheticRethrow;
    }
}

