/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.lexer;

import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;

public class LexerUtilities {
    public static TokenSequence<SQLTokenId> getTokenSequence(Document doc, int offset) {
        TokenSequence ts;
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        TokenSequence tokenSequence = ts = th == null ? null : th.tokenSequence(SQLTokenId.language());
        if (ts == null) {
            List list = th.embeddedTokenSequences(offset, true);
            for (TokenSequence t : list) {
                if (t.language() != SQLTokenId.language()) continue;
                ts = t;
                break;
            }
            if (ts == null) {
                list = th.embeddedTokenSequences(offset, false);
                for (TokenSequence t : list) {
                    if (t.language() != SQLTokenId.language()) continue;
                    ts = t;
                    break;
                }
            }
        }
        return ts;
    }

    public static OffsetRange findFwd(TokenSequence<? extends SQLTokenId> ts, int up, int down) {
        int balance = 0;
        while (ts.moveNext()) {
            Token token = ts.token();
            if (((SQLTokenId)token.id()).ordinal() == up) {
                ++balance;
                continue;
            }
            if (((SQLTokenId)token.id()).ordinal() != down) continue;
            if (balance == 0) {
                return new OffsetRange(ts.offset(), ts.offset() + token.length());
            }
            --balance;
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange findBwd(TokenSequence<? extends SQLTokenId> ts, int up, int down) {
        int balance = 0;
        while (ts.movePrevious()) {
            Token token = ts.token();
            if (((SQLTokenId)token.id()).ordinal() == up) {
                if (balance == 0) {
                    return new OffsetRange(ts.offset(), ts.offset() + token.length());
                }
                ++balance;
                continue;
            }
            if (((SQLTokenId)token.id()).ordinal() != down) continue;
            --balance;
        }
        return OffsetRange.NONE;
    }

    public static boolean textEquals(CharSequence text1, char ... text2) {
        int len = text1.length();
        if (len == text2.length) {
            for (int i = len - 1; i >= 0; --i) {
                if (text1.charAt(i) == text2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

