/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.ui.history;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import org.netbeans.modules.team.commons.ColorManager;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSHistoryProvider;
import org.netbeans.modules.versioning.core.util.VCSSystemProvider;
import org.netbeans.modules.versioning.ui.history.History;
import org.netbeans.modules.versioning.ui.history.HistoryComponent;
import org.netbeans.modules.versioning.ui.history.HistoryEntry;
import org.netbeans.modules.versioning.ui.history.HistoryRootNode;
import org.netbeans.modules.versioning.ui.history.HistorySettings;
import org.netbeans.modules.versioning.ui.history.HistoryUtils;
import org.netbeans.modules.versioning.ui.history.MsgTooltipWindow;
import org.netbeans.modules.versioning.ui.history.RevisionNode;
import org.netbeans.modules.versioning.ui.history.TableEntry;
import org.netbeans.modules.versioning.util.VCSHyperlinkProvider;
import org.netbeans.swing.etable.ETable;
import org.netbeans.swing.etable.ETableColumn;
import org.netbeans.swing.etable.ETableColumnModel;
import org.netbeans.swing.outline.DefaultOutlineCellRenderer;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.RenderDataProvider;
import org.netbeans.swing.outline.TreePathSupport;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.NodePopupFactory;
import org.openide.explorer.view.OutlineView;
import org.openide.explorer.view.Visualizer;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

class HistoryFileView
implements PreferenceChangeListener,
VCSHistoryProvider.HistoryChangeListener {
    private FileTablePanel tablePanel;
    private RequestProcessor rp = new RequestProcessor("HistoryView", 1, true);
    private final HistoryComponent tc;
    private HistoryComponent.Filter filter;
    private RequestProcessor.Task refreshTask;
    private RequestProcessor.Task vcsTask;
    private final VCSSystemProvider.VersioningSystem versioningSystem;
    private final VCSSystemProvider.VersioningSystem lh;
    private Date currentDateFrom;
    private LoadNextAction loadNextAction;
    private boolean visible;
    private VCSHistoryProvider pendingProviderToRefresh;
    private static final Icon NO_ICON = new NoIcon();

    public HistoryFileView(VCSSystemProvider.VersioningSystem versioningSystem, VCSSystemProvider.VersioningSystem lh, HistoryComponent tc) {
        this.tc = tc;
        this.versioningSystem = versioningSystem;
        this.lh = lh;
        this.visible = tc.isShowing();
        this.tablePanel = new FileTablePanel();
        this.loadNextAction = new LoadNextAction();
        HistoryFileView.registerHistoryListener(versioningSystem, this);
        HistorySettings.getInstance().addPreferenceListener(this);
        HistoryFileView.registerHistoryListener(lh, this);
    }

    public void refresh() {
        this.refreshTablePanel(null);
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        HistoryRootNode rootNode;
        if (("history.increments".equals(evt.getKey()) || "history.loadAll".equals(evt.getKey())) && (rootNode = this.getRootNode()) != null) {
            this.loadNextAction.refreshName();
        }
    }

    private HistoryRootNode getRootNode() {
        Node rootContext = this.tablePanel.getExplorerManager().getRootContext();
        if (rootContext == null || !(rootContext instanceof HistoryRootNode)) {
            return null;
        }
        return (HistoryRootNode)rootContext;
    }

    public ExplorerManager getExplorerManager() {
        return this.tablePanel.getExplorerManager();
    }

    public JPanel getPanel() {
        return this.tablePanel;
    }

    public void close() {
        HistoryFileView.unregisterHistoryListener(this.versioningSystem, this);
        HistoryFileView.unregisterHistoryListener(this.lh, this);
    }

    private synchronized void refreshTablePanel(final VCSHistoryProvider providerToRefresh) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                RequestProcessor.Task t = HistoryFileView.this.refreshTask;
                if (t != null) {
                    t.cancel();
                    if (HistoryFileView.this.vcsTask != null) {
                        HistoryFileView.this.vcsTask.cancel();
                        HistoryFileView.this.vcsTask = null;
                    }
                }
                t = HistoryFileView.this.rp.create((Runnable)new RefreshTable(this.mergeProvidersToRefresh(providerToRefresh, t)));
                HistoryFileView.this.refreshTask = t;
                if (HistoryFileView.this.visible) {
                    t.schedule(100);
                }
            }

            private VCSHistoryProvider mergeProvidersToRefresh(VCSHistoryProvider providerToRefresh2, RequestProcessor.Task t) {
                if (t != null && providerToRefresh2 != HistoryFileView.this.pendingProviderToRefresh) {
                    providerToRefresh2 = null;
                }
                return providerToRefresh2;
            }
        });
    }

    void requestActive() {
        this.visible = true;
        if (this.getRootNode() == null) {
            History.getInstance().getRequestProcessor().post(new Runnable(){

                @Override
                public void run() {
                    HistoryFileView.this.refresh();
                    HistoryFileView.this.tablePanel.requestActivate();
                }
            });
        } else {
            this.tablePanel.requestActivate();
            RequestProcessor.Task t = this.refreshTask;
            if (t != null) {
                t.schedule(100);
            }
        }
    }

    void hidden() {
        this.visible = false;
    }

    FileObject[] getFiles() {
        return this.tc.getFiles();
    }

    void setFilter(HistoryComponent.Filter filter) {
        this.filter = filter;
        this.tablePanel.treeView.getOutline().setQuickFilter(0, (Object)filter);
    }

    void fireFilterChanged() {
        this.tablePanel.treeView.getOutline().setQuickFilter(0, (Object)this.filter);
    }

    private void loadVCSEntries(final VCSFileProxy[] files, final boolean forceLoadAll) {
        if (this.versioningSystem == null) {
            return;
        }
        this.vcsTask = this.rp.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                VCSHistoryProvider.HistoryEntry[] vcsHistory;
                HistoryRootNode rootNode;
                block10: {
                    VCSHistoryProvider hp = HistoryFileView.this.versioningSystem.getVCSHistoryProvider();
                    if (hp == null) {
                        return;
                    }
                    rootNode = HistoryFileView.this.getRootNode();
                    if (rootNode == null) {
                        return;
                    }
                    rootNode.loadingVCSStarted();
                    if (forceLoadAll || HistorySettings.getInstance().getLoadAll()) {
                        vcsHistory = hp.getHistory(files, (Date)null);
                    } else {
                        int increment = HistorySettings.getInstance().getIncrements();
                        if (HistoryFileView.this.currentDateFrom == null) {
                            HistoryFileView.this.currentDateFrom = new Date(System.currentTimeMillis() - 86400000L * (long)increment);
                        } else {
                            HistoryFileView.this.currentDateFrom = new Date(HistoryFileView.this.currentDateFrom.getTime() - 86400000L * (long)increment);
                        }
                        vcsHistory = hp.getHistory(files, HistoryFileView.this.currentDateFrom);
                    }
                    if (vcsHistory != null && vcsHistory.length != 0) break block10;
                    rootNode.loadingVCSFinished(HistoryFileView.this.currentDateFrom);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            HistoryFileView.this.tablePanel.repaint();
                        }
                    });
                    return;
                }
                try {
                    ArrayList<HistoryEntry> entries = new ArrayList<HistoryEntry>(vcsHistory.length);
                    for (VCSHistoryProvider.HistoryEntry he : vcsHistory) {
                        entries.add(new HistoryEntry(he, false));
                    }
                    rootNode.addVCSEntries(entries.toArray(new HistoryEntry[entries.size()]), 0L);
                    rootNode.loadingVCSFinished(HistoryFileView.this.currentDateFrom);
                }
                catch (Throwable throwable) {
                    rootNode.loadingVCSFinished(HistoryFileView.this.currentDateFrom);
                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    private void restoreSelection(HistoryRootNode root, Node[] oldSelection) {
        this.tablePanel.getExplorerManager().setRootContext((Node)root);
        if (root.getChildren().getNodesCount() > 0) {
            if (oldSelection != null && oldSelection.length > 0) {
                Node[] newSelection = this.getEqualNodes((Node)root, oldSelection);
                if (newSelection.length > 0) {
                    this.setSelection(newSelection);
                } else {
                    Node[] newExploredContext = this.getEqualNodes((Node)root, new Node[]{oldSelection[0].getParentNode()});
                    if (newExploredContext.length > 0) {
                        this.selectFirstNeighborNode(newExploredContext[0], oldSelection[0]);
                    }
                }
            } else {
                this.selectFirstNode((Node)root);
            }
        } else {
            this.setSelection(new Node[0]);
        }
    }

    private Node[] getEqualNodes(Node root, Node[] oldNodes) {
        ArrayList<Node> ret = new ArrayList<Node>();
        for (Node on : oldNodes) {
            Node node = this.findEqualInChildren(root, on);
            if (node != null) {
                ret.add(node);
            }
            if (!root.getName().equals(on.getName())) continue;
            ret.add(root);
        }
        return ret.toArray(new Node[ret.size()]);
    }

    private Node findEqualInChildren(Node node, Node toFind) {
        Node[] children;
        for (Node child : children = node.getChildren().getNodes()) {
            if (toFind.getName().equals(child.getName())) {
                return child;
            }
            Node n = this.findEqualInChildren(child, toFind);
            if (n == null) continue;
            return n;
        }
        return null;
    }

    private void selectFirstNode(Node root) {
        Node[] nodes;
        Node[] dateFolders = root.getChildren().getNodes();
        if (dateFolders != null && dateFolders.length > 0 && (nodes = dateFolders[0].getChildren().getNodes()) != null && nodes.length > 0) {
            this.setSelection(new Node[]{nodes[0]});
        }
    }

    private void selectFirstNeighborNode(Node context, Node oldSelection) {
        Node[] children = context.getChildren().getNodes();
        if (children.length > 0 && children[0] instanceof Comparable) {
            Node[] newSelection = new Node[]{children[0]};
            for (int i = 1; i < children.length; ++i) {
                Comparable c = (Comparable)children[i];
                if (c.compareTo(oldSelection) >= 0) continue;
                newSelection[0] = children[i];
            }
            this.setSelection(newSelection);
            this.tablePanel.getExplorerManager().setExploredContext(context);
        }
    }

    private void setSelection(final Node[] nodes) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    HistoryFileView.this.tablePanel.getExplorerManager().setSelectedNodes(nodes);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        });
    }

    public void fireHistoryChanged(VCSHistoryProvider.HistoryEvent evt) {
        FileObject[] files = this.tc.getFiles();
        if (files == null) {
            return;
        }
        HashSet<FileObject> fileSet = new HashSet<FileObject>();
        for (VCSFileProxy vCSFileProxy : evt.getFiles()) {
            FileObject fo;
            FileObject fileObject = fo = vCSFileProxy != null ? vCSFileProxy.toFileObject() : null;
            if (fo == null) continue;
            fileSet.add(fo);
        }
        if (fileSet.isEmpty()) {
            return;
        }
        for (VCSFileProxy vCSFileProxy : files) {
            if (!fileSet.contains(vCSFileProxy)) continue;
            this.refreshTablePanel(evt.getSource());
        }
    }

    private static void registerHistoryListener(VCSSystemProvider.VersioningSystem versioningSystem, VCSHistoryProvider.HistoryChangeListener l) {
        VCSHistoryProvider hp = History.getHistoryProvider(versioningSystem);
        if (hp != null) {
            hp.addHistoryChangeListener(l);
        }
    }

    private static void unregisterHistoryListener(VCSSystemProvider.VersioningSystem versioningSystem, VCSHistoryProvider.HistoryChangeListener l) {
        VCSHistoryProvider hp = History.getHistoryProvider(versioningSystem);
        if (hp != null) {
            hp.removeHistoryChangeListener(l);
        }
    }

    HistoryEntry getParentEntry(HistoryEntry entry) {
        return this.getRootNode().getPreviousEntry(entry);
    }

    void selectPrevEntry() {
        Outline outline = this.tablePanel.treeView.getOutline();
        if (outline.getSelectedRowCount() != 1) {
            return;
        }
        int row = outline.getSelectedRow();
        if (row - 1 < 0) {
            return;
        }
        if ((row = this.getPrevRow(row)) > -1) {
            outline.getSelectionModel().setSelectionInterval(row, row);
            this.scrollToVisible(row, -1);
        }
    }

    private int getPrevRow(int row) {
        Outline outline = this.tablePanel.treeView.getOutline();
        if (--row < 0 || row >= outline.getRowCount()) {
            return -1;
        }
        TreePath path = outline.getOutlineModel().getLayout().getPathForRow(row);
        Node node = Visualizer.findNode((Object)path.getLastPathComponent());
        if (node.isLeaf()) {
            if (node instanceof RevisionNode || node instanceof RevisionNode.FileNode) {
                return row;
            }
            return -1;
        }
        TreePathSupport support = outline.getOutlineModel().getTreePathSupport();
        if (support.isExpanded(path)) {
            return this.getPrevRow(row);
        }
        support.expandPath(path);
        return row + node.getChildren().getNodesCount();
    }

    void selectNextEntry() {
        Outline outline = this.tablePanel.treeView.getOutline();
        if (outline.getSelectedRowCount() != 1) {
            return;
        }
        int row = outline.getSelectedRow();
        if (row == outline.getRowCount() - 1) {
            return;
        }
        if ((row = this.getNextRow(row)) > -1) {
            outline.getSelectionModel().setSelectionInterval(row, row);
            this.scrollToVisible(row, 1);
        }
    }

    private int getNextRow(int row) {
        Outline outline = this.tablePanel.treeView.getOutline();
        if (++row < 0 || row >= outline.getRowCount()) {
            return -1;
        }
        TreePath path = outline.getOutlineModel().getLayout().getPathForRow(row);
        Node node = Visualizer.findNode((Object)path.getLastPathComponent());
        if (node.isLeaf()) {
            if (node instanceof RevisionNode || node instanceof RevisionNode.FileNode) {
                return row;
            }
            return -1;
        }
        TreePathSupport support = outline.getOutlineModel().getTreePathSupport();
        if (support.isExpanded(path)) {
            return this.getPrevRow(row);
        }
        support.expandPath(path);
        return row + 1;
    }

    boolean isFirstRow() {
        return this.tablePanel.treeView.getOutline().getSelectedRow() == 0;
    }

    boolean isLastRow() {
        Outline outline = this.tablePanel.treeView.getOutline();
        return outline.getSelectedRow() == outline.getRowCount() - 1;
    }

    boolean isSingleSelection() {
        int[] rows = this.tablePanel.treeView.getOutline().getSelectedRows();
        return rows != null && rows.length == 1;
    }

    private void scrollToVisible(int row, int direction) {
        Outline outline = this.tablePanel.treeView.getOutline();
        Rectangle rect = outline.getCellRect(row, 0, true);
        outline.scrollRectToVisible(new Rectangle(new Point(0, rect.y + direction * rect.height)));
    }

    private void logFiles(String prefix, FileObject[] fos) {
        if (fos != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(prefix);
            for (int i = 0; i < fos.length; ++i) {
                FileObject fo = fos[i];
                sb.append(fo.getPath());
                if (i >= fos.length - 1) continue;
                sb.append(",");
            }
            History.LOG.fine(sb.toString());
        }
    }

    private HistoryEntry[] loadLHEntries(VCSFileProxy[] files) {
        if (this.lh == null) {
            return new HistoryEntry[0];
        }
        VCSHistoryProvider hp = this.lh.getVCSHistoryProvider();
        if (hp == null) {
            return new HistoryEntry[0];
        }
        VCSHistoryProvider.HistoryEntry[] vcsHistory = hp.getHistory(files, null);
        HistoryEntry[] history = new HistoryEntry[vcsHistory.length];
        for (int i = 0; i < vcsHistory.length; ++i) {
            history[i] = new HistoryEntry(vcsHistory[i], true);
        }
        return history;
    }

    private Action[] createActions() {
        LinkedList<AbstractAction> actions = new LinkedList<AbstractAction>();
        actions.add(this.loadNextAction);
        actions.add(new AbstractAction(NbBundle.getMessage(HistoryFileView.class, (String)"LBL_LoadAll")){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoryFileView.this.loadVCSEntries(History.toProxies(HistoryFileView.this.tc.getFiles()), true);
            }
        });
        actions.add(null);
        actions.add(new AbstractAction(NbBundle.getMessage(HistoryFileView.class, (String)"LBL_AlwaysLoadAll")){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistorySettings.getInstance().setLoadAll(true);
                HistoryFileView.this.loadVCSEntries(History.toProxies(HistoryFileView.this.tc.getFiles()), true);
            }
        });
        return actions.toArray(new Action[actions.size()]);
    }

    private boolean containsHyperlink(String message) throws IllegalAccessException {
        int[] spans = this.getHyperlinkSpans(message);
        return spans != null && spans.length >= 2;
    }

    private int[] getHyperlinkSpans(String message) throws IllegalAccessException {
        List<VCSHyperlinkProvider> providers = History.getInstance().getHyperlinkProviders();
        for (VCSHyperlinkProvider hp : providers) {
            int[] spans = hp.getSpans(message);
            if (spans == null || spans.length < 2) continue;
            return spans;
        }
        return null;
    }

    private static void appendHyperlinkHTMLFont(StringBuilder sb) {
        sb.append("<font color=#");
        sb.append(Integer.toHexString(ColorManager.getDefault().getLinkColor().getRGB() & 0xFFFFFF));
        sb.append(">");
    }

    private class LoadNextAction
    extends AbstractAction {
        public LoadNextAction() {
            this.refreshName();
        }

        private void refreshName() {
            final String name = HistorySettings.getInstance().getLoadAll() ? NbBundle.getMessage(HistoryRootNode.class, (String)"LBL_LoadAll") : NbBundle.getMessage(HistoryRootNode.class, (String)"LBL_LoadNext", (Object)HistorySettings.getInstance().getIncrements());
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    LoadNextAction.this.putValue("Name", name);
                    HistoryRootNode rootNode = HistoryFileView.this.getRootNode();
                    if (rootNode != null) {
                        rootNode.refreshLoadNextName();
                    }
                }
            };
            if (EventQueue.isDispatchThread()) {
                r.run();
            } else {
                EventQueue.invokeLater(r);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HistoryFileView.this.loadVCSEntries(History.toProxies(HistoryFileView.this.tc.getFiles()), false);
        }
    }

    private class TableMouseListener
    implements MouseListener,
    MouseMotionListener {
        private final Outline outline;
        private boolean pressedPopup = false;

        public TableMouseListener(Outline outline) {
            this.outline = outline;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            try {
                Object value = this.getValue(e);
                if (value instanceof RevisionNode.MessageProperty) {
                    RevisionNode.MessageProperty msg = (RevisionNode.MessageProperty)((Object)value);
                    if (msg == null || !HistoryFileView.this.containsHyperlink(msg.getValue().getDisplayValue())) {
                        this.outline.setCursor(Cursor.getPredefinedCursor(0));
                    } else {
                        this.outline.setCursor(Cursor.getPredefinedCursor(12));
                    }
                }
            }
            catch (Exception ex) {
                History.LOG.log(Level.WARNING, null, ex);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TreePath path = this.outline.getClosestPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return;
            }
            Node n = Visualizer.findNode((Object)path.getPathComponent(1));
            if (n == null) {
                return;
            }
            if (!this.pressedPopup && HistoryRootNode.isLoadNext(Visualizer.findNode((Object)n))) {
                HistoryFileView.this.loadNextAction.actionPerformed(null);
            } else {
                Object value = this.getValue(e);
                if (!(value instanceof RevisionNode.MessageProperty)) {
                    return;
                }
                RevisionNode.MessageProperty messageProperty = (RevisionNode.MessageProperty)((Object)value);
                if (messageProperty == null) {
                    return;
                }
                try {
                    this.outline.getSelectedRow();
                    HistoryEntry entry = (HistoryEntry)n.getLookup().lookup(HistoryEntry.class);
                    if (entry == null) {
                        return;
                    }
                    String message = entry.getMessage();
                    String author = entry.getUsername();
                    String revision = entry.getRevision();
                    Date date = entry.getDateTime();
                    FileObject[] files = HistoryFileView.this.tc.getFiles();
                    VCSFileProxy file = files[0] != null ? VCSFileProxy.createFileProxy((FileObject)files[0]) : null;
                    MsgTooltipWindow ttw = new MsgTooltipWindow((JComponent)this.outline, file, message, revision, author, date);
                    Point p = e.getPoint();
                    SwingUtilities.convertPointToScreen(p, (Component)this.outline);
                    ttw.show(new Point(p.x, p.y));
                }
                catch (Exception ex) {
                    History.LOG.log(Level.WARNING, null, ex);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.pressedPopup = e.isPopupTrigger();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private Object getValue(MouseEvent e) {
            int r = this.outline.rowAtPoint(e.getPoint());
            int c = this.outline.columnAtPoint(e.getPoint());
            if (r == -1 || c == -1) {
                return null;
            }
            return this.outline.getValueAt(r, c);
        }
    }

    private class PropertyRenderer
    extends DefaultOutlineCellRenderer {
        private final Outline outline;

        public PropertyRenderer(Outline outline) {
            this.outline = outline;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer;
            if (value instanceof Node.Property) {
                try {
                    int[] spans;
                    String[] lines;
                    String valueString = this.getDisplayValue((Node.Property)value);
                    valueString = HistoryUtils.computeFitText(table, row, column, valueString);
                    valueString = HistoryFileView.this.filter != null && HistoryFileView.this.filter.filtersProperty((Node.Property)value) ? HistoryFileView.this.filter.getRendererValue(valueString) : HistoryUtils.escapeForHTMLLabel(valueString);
                    if (value instanceof RevisionNode.MessageProperty && (lines = valueString.split("\n")).length > 0 && (spans = HistoryFileView.this.getHyperlinkSpans(lines[0])) != null && spans.length >= 2) {
                        StringBuilder sb = new StringBuilder();
                        String line = this.addHyperlink(HistoryUtils.escapeForHTMLLabel(lines[0]), spans);
                        sb.append(line);
                        for (int i = 1; i < lines.length; ++i) {
                            sb.append("\n");
                            sb.append(HistoryUtils.escapeForHTMLLabel(lines[i]));
                        }
                        valueString = sb.toString();
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append("<html>");
                    sb.append(valueString);
                    sb.append("</html>");
                    valueString = sb.toString();
                    renderer = super.getTableCellRendererComponent(table, (Object)valueString, isSelected, hasFocus, row, column);
                    if (renderer instanceof JComponent) {
                        JComponent comp = (JComponent)renderer;
                        comp.setToolTipText(this.getTooltip((Node.Property)value));
                    }
                }
                catch (Exception ex) {
                    History.LOG.log(Level.WARNING, null, ex);
                    renderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
            } else {
                renderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            renderer.setBackground(isSelected ? this.outline.getSelectionBackground() : this.outline.getBackground());
            return renderer;
        }

        String getDisplayValue(Node.Property p) throws IllegalAccessException, InvocationTargetException {
            TableEntry value = (TableEntry)p.getValue();
            return value != null ? value.getDisplayValue() : "";
        }

        String getTooltip(Node.Property p) throws IllegalAccessException, InvocationTargetException {
            Object value = p.getValue();
            if (value instanceof TableEntry) {
                return ((TableEntry)value).getTooltip();
            }
            String tooltip = p.toString();
            if (tooltip != null && tooltip.contains("\n")) {
                tooltip = HistoryUtils.escapeForHTMLLabel(tooltip);
                StringBuilder sb = new StringBuilder();
                sb.append("<html>");
                StringTokenizer st = new StringTokenizer(tooltip, "\n");
                while (true) {
                    sb.append(st.nextToken());
                    if (!st.hasMoreTokens()) break;
                    sb.append("<br>");
                }
                sb.append("</html>");
                tooltip = sb.toString();
            }
            return tooltip;
        }

        private String addHyperlink(String s, int[] spans) {
            assert (spans.length % 2 == 0);
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < spans.length) {
                int start = spans[i++];
                if (i == 1) {
                    sb.append(s.substring(0, start));
                    HistoryFileView.appendHyperlinkHTMLFont(sb);
                    sb.append("<u>");
                }
                int end = spans[i++];
                sb.append(s.substring(start, end));
                if (i != spans.length) continue;
                sb.append("</u></font>");
                sb.append(s.substring(end, s.length()));
            }
            return sb.toString();
        }
    }

    private static class NoIcon
    implements Icon {
        private NoIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public int getIconHeight() {
            return 0;
        }
    }

    private class FileTablePanel
    extends JPanel
    implements ExplorerManager.Provider,
    TreeExpansionListener {
        private final BrowserTreeTableView treeView;
        private final ExplorerManager manager = new ExplorerManager();

        public FileTablePanel() {
            this.setLayout(new GridBagLayout());
            this.treeView = new BrowserTreeTableView();
            this.treeView.addTreeExpansionListener(this);
            this.setLayout(new BorderLayout());
            this.add((Component)((Object)this.treeView), "Center");
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }

        void requestActivate() {
            this.treeView.requestFocusInWindow();
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            Object obj = event.getPath().getLastPathComponent();
            if (obj == null) {
                return;
            }
            Node n = Visualizer.findNode((Object)obj);
            if (HistoryRootNode.isLoadNext(n)) {
                HistoryFileView.this.loadNextAction.actionPerformed(null);
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
        }

        private class BrowserTreeTableView
        extends OutlineView {
            BrowserTreeTableView() {
                super(NbBundle.getMessage(HistoryFileView.class, (String)"LBL_LocalHistory_Column_Date"));
                this.setupColumns();
                this.getOutline().setShowHorizontalLines(true);
                this.getOutline().setShowVerticalLines(false);
                this.getOutline().setRootVisible(false);
                this.setBorder(BorderFactory.createEtchedBorder());
                this.getOutline().setSelectionMode(2);
                this.setPopupAllowed(true);
                this.setDragSource(false);
                this.setDropTarget(false);
                this.getOutline().setColumnHidingAllowed(false);
                this.getOutline().setRenderDataProvider((RenderDataProvider)new NoLeafIconRenderDataProvider(this.getOutline().getRenderDataProvider()));
                this.getOutline().setDefaultRenderer(Node.Property.class, (TableCellRenderer)((Object)new PropertyRenderer(this.getOutline())));
                TableMouseListener l = new TableMouseListener(this.getOutline());
                this.getOutline().addMouseMotionListener((MouseMotionListener)l);
                this.getOutline().addMouseListener((MouseListener)l);
                this.setNodePopupFactory(new NodePopupFactory(){
                    private final String[] quickFilterFormatStrings = new String[]{"{0} == {1}", "{0} <> {1}", "{0} > {1}", "{0} < {1}", "{0} >= {1}", "{0} <= {1}", NbBundle.getMessage(HistoryFileView.class, (String)"LBL_NoFilter")};

                    public JPopupMenu createPopupMenu(int row, int column, Node[] selectedNodes, Component component) {
                        Action[] actions = NodeOp.findActions((Node[])selectedNodes);
                        JPopupMenu res = Utilities.actionsToPopup((Action[])actions, (Component)component);
                        if (component instanceof ETable && column >= 0) {
                            ETable et = (ETable)component;
                            if (row >= 0) {
                                Object val = et.getValueAt(row, column);
                                val = et.transformValue(val);
                                String s = NbBundle.getMessage(HistoryFileView.class, (String)"LBL_QuickFilter");
                                res.add(this.getQuickFilterPopup(et, column, val, s));
                            } else if (et.getQuickFilterColumn() == column && et.getQuickFilterColumn() != -1) {
                                String s = NbBundle.getMessage(HistoryFileView.class, (String)"LBL_QuickFilter");
                                JMenu menu = new JMenu(s);
                                JMenuItem noFilterItem = et.getQuickFilterNoFilterItem(et.getQuickFilterFormatStrings()[6]);
                                menu.add(noFilterItem);
                                res.add(menu);
                            }
                        }
                        return res;
                    }

                    public JMenuItem getQuickFilterPopup(ETable et, int column, Object value, String label) {
                        JMenu menu = new JMenu(label);
                        String columnDisplayName = et.getColumnDisplayName(et.getColumnName(column));
                        boolean isDate = value instanceof RevisionNode;
                        JMenuItem equalsItem = et.getQuickFilterEqualsItem(column, value, columnDisplayName, this.quickFilterFormatStrings[0], true);
                        menu.add(equalsItem);
                        JMenuItem notequalsItem = et.getQuickFilterEqualsItem(column, value, columnDisplayName, this.quickFilterFormatStrings[1], false);
                        menu.add(notequalsItem);
                        if (isDate) {
                            JMenuItem greaterItem = et.getQuickFilterCompareItem(column, value, columnDisplayName, this.quickFilterFormatStrings[2], true, false);
                            menu.add(greaterItem);
                            JMenuItem lessItem = et.getQuickFilterCompareItem(column, value, columnDisplayName, this.quickFilterFormatStrings[3], false, false);
                            menu.add(lessItem);
                            JMenuItem greaterEqualsItem = et.getQuickFilterCompareItem(column, value, columnDisplayName, this.quickFilterFormatStrings[4], true, true);
                            menu.add(greaterEqualsItem);
                            JMenuItem lessEqualsItem = et.getQuickFilterCompareItem(column, value, columnDisplayName, this.quickFilterFormatStrings[5], false, true);
                            menu.add(lessEqualsItem);
                            JMenuItem noFilterItem = et.getQuickFilterNoFilterItem(this.quickFilterFormatStrings[6]);
                            menu.add(noFilterItem);
                        }
                        return menu;
                    }
                });
            }

            public void addNotify() {
                super.addNotify();
                this.setDefaultColumnSizes();
            }

            private void setupColumns() {
                ResourceBundle loc = NbBundle.getBundle(FileTablePanel.class);
                if (HistoryFileView.this.versioningSystem != null) {
                    this.addPropertyColumn("version", loc.getString("LBL_LocalHistory_Column_Version"));
                    this.setPropertyColumnDescription("version", loc.getString("LBL_LocalHistory_Column_Version_Desc"));
                    this.addPropertyColumn("user", loc.getString("LBL_LocalHistory_Column_User"));
                    this.setPropertyColumnDescription("user", loc.getString("LBL_LocalHistory_Column_User_Desc"));
                }
                this.addPropertyColumn("label", loc.getString("LBL_LocalHistory_Column_Label"));
                this.setPropertyColumnDescription("label", loc.getString("LBL_LocalHistory_Column_Label_Desc"));
                ETableColumnModel m = (ETableColumnModel)this.getOutline().getColumnModel();
                ETableColumn etc = (ETableColumn)m.getColumn(0);
                etc.setNestedComparator((Comparator)new NodeComparator(etc));
                m.setColumnSorted(etc, false, 1);
                int idx = 1;
                if (HistoryFileView.this.versioningSystem != null) {
                    this.setPropertyComparator(idx++);
                    this.setPropertyComparator(idx++);
                }
                this.setPropertyComparator(idx++);
            }

            private void setPropertyComparator(int idx) {
                ETableColumn etc1 = (ETableColumn)this.getOutline().getColumnModel().getColumn(idx++);
                etc1.setNestedComparator((Comparator)new PropertyComparator(etc1));
            }

            private void setDefaultColumnSizes() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int width = BrowserTreeTableView.this.getWidth();
                        BrowserTreeTableView.this.getOutline().getColumnModel().getColumn(0).setPreferredWidth(width * 20 / 100);
                        if (HistoryFileView.this.versioningSystem != null) {
                            BrowserTreeTableView.this.getOutline().getColumnModel().getColumn(1).setPreferredWidth(width * 10 / 100);
                            BrowserTreeTableView.this.getOutline().getColumnModel().getColumn(2).setPreferredWidth(width * 10 / 100);
                            BrowserTreeTableView.this.getOutline().getColumnModel().getColumn(3).setPreferredWidth(width * 60 / 100);
                        } else {
                            BrowserTreeTableView.this.getOutline().getColumnModel().getColumn(1).setPreferredWidth(width * 80 / 100);
                        }
                    }
                });
            }

            private class NoLeafIconRenderDataProvider
            implements RenderDataProvider {
                private RenderDataProvider delegate;

                public NoLeafIconRenderDataProvider(RenderDataProvider delegate) {
                    this.delegate = delegate;
                }

                public String getDisplayName(Object o) {
                    Node n = Visualizer.findNode((Object)o);
                    if (HistoryRootNode.isLoadNext(n)) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("<html>");
                        HistoryFileView.appendHyperlinkHTMLFont(sb);
                        sb.append(this.delegate.getDisplayName(o));
                        sb.append("</font></html>");
                        return sb.toString();
                    }
                    return this.delegate.getDisplayName(o);
                }

                public boolean isHtmlDisplayName(Object o) {
                    Node n = Visualizer.findNode((Object)o);
                    if (HistoryRootNode.isLoadNext(n)) {
                        return true;
                    }
                    return this.delegate.isHtmlDisplayName(o);
                }

                public Color getBackground(Object o) {
                    Color b = this.delegate.getBackground(o);
                    return b;
                }

                public Color getForeground(Object o) {
                    return this.delegate.getForeground(o);
                }

                public String getTooltipText(Object o) {
                    return this.delegate.getTooltipText(o);
                }

                public Icon getIcon(Object o) {
                    Node n = Visualizer.findNode((Object)o);
                    if (HistoryRootNode.isWait(n)) {
                        return this.delegate.getIcon(o);
                    }
                    if (BrowserTreeTableView.this.getOutline().getOutlineModel().isLeaf(o) || HistoryRootNode.isLoadNext(n)) {
                        return NO_ICON;
                    }
                    return null;
                }
            }

            private class PropertyComparator
            implements Comparator<TableEntry> {
                private final ETableColumn etc;

                public PropertyComparator(ETableColumn etc) {
                    this.etc = etc;
                }

                @Override
                public int compare(TableEntry e1, TableEntry e2) {
                    Integer so2;
                    if (e1 == null && e2 == null) {
                        return 0;
                    }
                    if (e1 == null) {
                        return -1;
                    }
                    if (e2 == null) {
                        return 1;
                    }
                    Integer so1 = e1.order();
                    int c = so1.compareTo(so2 = e2.order());
                    if (c == 0) {
                        return e1.compareTo(e2);
                    }
                    return this.etc.isAscending() ? -c : c;
                }
            }

            private class NodeComparator
            implements Comparator<Node> {
                private final ETableColumn etc;

                public NodeComparator(ETableColumn etc) {
                    this.etc = etc;
                }

                @Override
                public int compare(Node n1, Node n2) {
                    if (HistoryRootNode.isLoadNext(n1) || HistoryRootNode.isWait(n1)) {
                        return this.etc.isAscending() ? 1 : -1;
                    }
                    if (HistoryRootNode.isLoadNext(n2) || HistoryRootNode.isWait(n2)) {
                        return this.etc.isAscending() ? -1 : 1;
                    }
                    if (n1 instanceof Comparable) {
                        return ((Comparable)n1).compareTo(n2);
                    }
                    if (n2 instanceof Comparable) {
                        return -((Comparable)n2).compareTo(n1);
                    }
                    return n1.getName().compareTo(n2.getName());
                }
            }
        }
    }

    private class RefreshTable
    implements Runnable {
        private final VCSHistoryProvider providerToRefresh;

        RefreshTable(VCSHistoryProvider providerToRefresh) {
            this.providerToRefresh = providerToRefresh;
            HistoryFileView.this.pendingProviderToRefresh = providerToRefresh;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HistoryRootNode root = HistoryFileView.this.getRootNode();
            if (root == null) {
                String vcsName = History.getHistoryProvider(HistoryFileView.this.versioningSystem) != null ? HistoryFileView.this.versioningSystem.getDisplayName() : null;
                root = new HistoryRootNode(vcsName, HistoryFileView.this.loadNextAction, HistoryFileView.this.createActions());
                HistoryFileView.this.tablePanel.getExplorerManager().setRootContext((Node)root);
            }
            FileObject[] fos = HistoryFileView.this.tc.getFiles();
            VCSFileProxy[] proxies = History.toProxies(fos);
            try {
                root.addWaitNode();
                VCSHistoryProvider lhProvider = History.getHistoryProvider(HistoryFileView.this.lh);
                if (lhProvider != null && (this.providerToRefresh == null || lhProvider == this.providerToRefresh)) {
                    HistoryFileView.this.logFiles("Refreshing LH entries for: ", fos);
                    root.addLHEntries(HistoryFileView.this.loadLHEntries(proxies), 0L);
                }
            }
            finally {
                root.removeWaitNode();
            }
            VCSHistoryProvider vcsProvider = History.getHistoryProvider(HistoryFileView.this.versioningSystem);
            if (HistoryFileView.this.tc != null && vcsProvider != null && (this.providerToRefresh == null || this.providerToRefresh == vcsProvider)) {
                HistoryFileView.this.logFiles("Refreshing VCS entries for: ", fos);
                HistoryFileView.this.loadVCSEntries(proxies, false);
            }
            HistoryFileView.this.refreshTask = null;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HistoryFileView.this.tablePanel.revalidate();
                    HistoryFileView.this.tablePanel.repaint();
                    int row = HistoryFileView.this.tablePanel.treeView.getOutline().getSelectedRow();
                    if (row > -1) {
                        HistoryFileView.this.scrollToVisible(row, 2);
                    }
                }
            });
        }
    }
}

