/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi.infomodel;

import com.sun.xml.registry.uddi.infomodel.ExternalLinkImpl;
import com.sun.xml.registry.uddi.infomodel.InternationalStringImpl;
import com.sun.xml.registry.uddi.infomodel.KeyImpl;
import com.sun.xml.registry.uddi.infomodel.RegistryObjectImpl;
import com.sun.xml.registry.uddi.infomodel.ServiceBindingImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.UnexpectedObjectException;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.SpecificationLink;

public class SpecificationLinkImpl
extends RegistryObjectImpl
implements SpecificationLink,
Serializable {
    private Concept registryObject;
    private InternationalString usageDescription;
    private ArrayList usageParameters = new ArrayList();
    private ServiceBinding serviceBinding;

    public SpecificationLinkImpl() {
        this.usageDescription = new InternationalStringImpl();
    }

    public RegistryObject getSpecificationObject() {
        return this.registryObject;
    }

    public void setSpecificationObject(RegistryObject obj) throws JAXRException {
        if (!(obj instanceof Concept)) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("SpecificationLinkImpl:For_UDDI_provider,_object_must_be_a_Concept"));
        }
        this.registryObject = (Concept)obj;
        this.setIsModified(true);
    }

    public InternationalString getUsageDescription() {
        return this.usageDescription;
    }

    public void setUsageDescription(InternationalString usageDescription) {
        this.usageDescription = usageDescription;
        this.setIsModified(true);
    }

    public Collection getUsageParameters() {
        return (Collection)this.usageParameters.clone();
    }

    public void setUsageParameters(Collection usageParameters) throws JAXRException {
        if (usageParameters == null) {
            this.usageParameters.clear();
        } else {
            if (usageParameters.size() > 1) {
                throw new InvalidRequestException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("SpecificationLinkImpl:single_usage_parameter_must_be_specified"));
            }
            for (Object object : usageParameters) {
                if (!(object instanceof String)) {
                    throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("SpecificationLinkImpl:usage_parameters_must_be_strings"));
                }
                if (((String)object).length() > 255) {
                    throw new InvalidRequestException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("SpecificationLinkImpl:usage_parameters_size_must_be_less_than_255"));
                }
                this.usageParameters.add(object);
            }
        }
        this.setIsModified(true);
    }

    public ServiceBinding getServiceBinding() {
        return this.serviceBinding;
    }

    public void setServiceBinding(ServiceBinding binding) {
        this.serviceBinding = binding;
    }

    @Override
    public void addExternalLink(ExternalLink link) throws JAXRException {
        if (this.externalLinks.size() > 0) {
            throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("SpecificationLinkImpl:ExternalLink_already_exists,_cannot_add_more."));
        }
        if (link != null) {
            ExternalLinkImpl externalLink = (ExternalLinkImpl)link;
            externalLink.addLinkedObject(this);
            this.externalLinks.add(externalLink);
            this.setIsModified(true);
        }
    }

    @Override
    public void addExternalLinks(Collection links) throws JAXRException {
        if (this.externalLinks.size() > 0) {
            throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("SpecificationLinkImpl:ExternalLink_already_exists,_cannot_add_more."));
        }
        if (links != null) {
            if (links.size() > 1) {
                throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("SpecificationLinkImpl:Cannot_add_more_than_one_ExternalLink"));
            }
            Iterator iter = links.iterator();
            try {
                while (iter.hasNext()) {
                    this.addExternalLink((ExternalLink)iter.next());
                }
            }
            catch (ClassCastException e) {
                throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("SpecificationLinkImpl:Objects_in_collection_must_be_ExternalLinks"), (Throwable)e);
            }
        }
    }

    @Override
    public void setExternalLinks(Collection links) throws JAXRException {
        if (links == null) {
            this.externalLinks.clear();
            return;
        }
        if (links.size() > 0) {
            throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("SpecificationLinkImpl:Cannot_set_more_than_one_link."));
        }
        this.externalLinks.clear();
        this.addExternalLinks(links);
    }

    @Override
    public Key getKey() throws JAXRException {
        if (this.serviceBinding == null || this.serviceBinding.getKey() == null) {
            return null;
        }
        Service service = this.serviceBinding.getService();
        if (service == null || service.getKey() == null) {
            return null;
        }
        if (this.registryObject == null || this.registryObject.getKey() == null) {
            return null;
        }
        int sequenceId = ((ServiceBindingImpl)this.serviceBinding).getSequenceId(this);
        String id = service.getKey().getId() + ":" + this.serviceBinding.getAccessURI() + ":" + this.serviceBinding.getKey().getId() + ":" + sequenceId + ":" + this.registryObject.getKey().getId();
        return new KeyImpl(id);
    }
}

