/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.tools.wscompile;

import com.sun.xml.rpc.processor.Processor;
import com.sun.xml.rpc.processor.config.J2EEModelInfo;
import com.sun.xml.rpc.processor.config.parser.Constants;
import com.sun.xml.rpc.processor.config.parser.J2EEModelInfoParser;
import com.sun.xml.rpc.processor.config.parser.ModelInfoParser;
import com.sun.xml.rpc.processor.config.parser.ModelInfoPlugin;
import com.sun.xml.rpc.processor.generator.JaxRpcMappingGenerator;
import com.sun.xml.rpc.processor.modeler.j2ee.JaxRpcMappingXml;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.spi.tools.ModelInfo;
import com.sun.xml.rpc.tools.plugin.ToolPlugin;
import com.sun.xml.rpc.tools.wscompile.ProcessorActionsIf;
import com.sun.xml.rpc.tools.wscompile.UsageIf;
import com.sun.xml.rpc.util.localization.Localizable;
import com.sun.xml.rpc.util.localization.LocalizableMessageFactory;
import com.sun.xml.rpc.util.localization.Localizer;
import java.io.File;
import java.net.URL;
import javax.xml.namespace.QName;

public class J2EEToolPlugin
extends ToolPlugin
implements UsageIf,
ModelInfoPlugin,
ProcessorActionsIf {
    private LocalizableMessageFactory messageFactory;
    protected Localizer localizer = new Localizer();
    protected File mappingFile = null;

    public J2EEToolPlugin() {
        this.messageFactory = new LocalizableMessageFactory("com.sun.xml.rpc.resources.j2ee");
    }

    @Override
    public QName getModelInfoName() {
        return Constants.QNAME_J2EE_MAPPING_FILE;
    }

    @Override
    public ModelInfoParser createModelInfoParser(ProcessorEnvironment env) {
        return new J2EEModelInfoParser(env);
    }

    @Override
    public ModelInfo createModelInfo(URL mappingFile) throws Exception {
        JaxRpcMappingXml mapping = new JaxRpcMappingXml(mappingFile.toExternalForm());
        J2EEModelInfo modelInfo = new J2EEModelInfo(mapping);
        return modelInfo;
    }

    @Override
    public ModelInfo createModelInfo() {
        return new J2EEModelInfo();
    }

    @Override
    public Localizable getOptionsUsage() {
        return this.messageFactory.getMessage("j2ee.usage.options", (Object[])null);
    }

    @Override
    public Localizable getFeaturesUsage() {
        return null;
    }

    @Override
    public Localizable getInternalUsage() {
        return null;
    }

    @Override
    public Localizable getExamplesUsage() {
        return null;
    }

    @Override
    public boolean parseArguments(String[] args, UsageIf.UsageError err) {
        this.mappingFile = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null || !args[i].equals("-mapping")) continue;
            if (i + 1 < args.length) {
                if (this.mappingFile != null) {
                    err.msg = this.messageFactory.getMessage("j2ee.duplicateOption", new Object[]{"-mapping"});
                    return false;
                }
                args[i] = null;
                this.mappingFile = new File(args[++i]);
                args[i] = null;
                continue;
            }
            err.msg = this.messageFactory.getMessage("j2ee.missingOptionArgument", new Object[]{"-mapping"});
            return false;
        }
        return true;
    }

    @Override
    public void registerActions(Processor processor) {
        if (this.mappingFile != null) {
            processor.add(new JaxRpcMappingGenerator(this.mappingFile));
        }
    }
}

