/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss;

import com.sun.xml.ws.api.ha.HighAvailabilityProvider;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.commons.AbstractMOMRegistrationAware;
import com.sun.xml.ws.commons.MOMRegistrationAware;
import com.sun.xml.ws.commons.WSEndpointCollectionBasedMOMListener;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.impl.misc.DefaultNonceManager;
import com.sun.xml.wss.impl.misc.HANonceManager;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import java.net.URL;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@ManagedObject
@Description(value="per-endpoint NonceManager")
@AMXMetadata(type="WSNonceManager")
public abstract class NonceManager
extends AbstractMOMRegistrationAware {
    protected static final Logger LOGGER = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    public static final String nonceManager = "com.sun.xml.xwss.NonceManager";
    private static final String NONCE_MANAGER = "NonceManager";
    private static WeakHashMap<WSEndpoint, NonceManager> nonceMgrMap = new WeakHashMap();
    private static NonceManager jaxRPCNonceManager = null;
    private long maxNonceAge;
    private static final Object LOCK = new Object();
    private static final WSEndpointCollectionBasedMOMListener listener = new WSEndpointCollectionBasedMOMListener<NonceManager>(LOCK, "NonceManager", nonceMgrMap);

    @ManagedAttribute
    public long getMaxNonceAge() {
        return this.maxNonceAge;
    }

    public void setMaxNonceAge(long maxNonceAge) {
        this.maxNonceAge = maxNonceAge;
    }

    public abstract boolean validateNonce(String var1, String var2) throws NonceException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NonceManager getInstance(long maxNonceAge, WSEndpoint endpoint) {
        Object object = LOCK;
        synchronized (object) {
            NonceManager nonceMgr;
            if (endpoint == null && LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, String.format("getInstance(): endpoint is null: using singleton", new Object[0]));
            }
            NonceManager nonceManager = nonceMgr = endpoint != null ? nonceMgrMap.get(endpoint) : jaxRPCNonceManager;
            if (nonceMgr != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, String.format("getInstance(%s): found existing: %s", endpoint, nonceMgr));
                }
                return nonceMgr;
            }
            URL url = SecurityUtil.loadFromClasspath("/META-INF/services/com.sun.xml.xwss.NonceManager");
            if (url != null) {
                Object obj = SecurityUtil.loadSPIClass(url, nonceManager);
                if (obj != null && !(obj instanceof NonceManager)) {
                    throw new XWSSecurityRuntimeException("Class :" + obj.getClass().getName() + " is not a valid NonceManager");
                }
                nonceMgr = (NonceManager)obj;
            }
            if (HighAvailabilityProvider.INSTANCE.isHaEnvironmentConfigured()) {
                nonceMgr = new HANonceManager(maxNonceAge);
            } else if (url == null) {
                nonceMgr = new DefaultNonceManager();
            }
            if (nonceMgr == null) {
                nonceMgr = new DefaultNonceManager();
            }
            nonceMgr.setMaxNonceAge(maxNonceAge);
            if (endpoint != null) {
                nonceMgrMap.put(endpoint, nonceMgr);
                if (listener.canRegisterAtMOM()) {
                    listener.registerAtMOM((MOMRegistrationAware)nonceMgr, endpoint);
                }
            } else {
                jaxRPCNonceManager = nonceMgr;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, String.format("getInstance(%s): created: %s", endpoint, nonceMgr));
            }
            return nonceMgr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteInstance(WSEndpoint endpoint) {
        Object object = LOCK;
        synchronized (object) {
            NonceManager o;
            NonceManager nonceManager = o = endpoint != null ? nonceMgrMap.remove(endpoint) : jaxRPCNonceManager;
            if (endpoint == null) {
                jaxRPCNonceManager = null;
            }
            NonceManager nonceManager2 = o;
            if (endpoint != null && o != null && nonceManager2.isRegisteredAtMOM()) {
                listener.unregisterFromMOM((MOMRegistrationAware)nonceManager2, endpoint);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, String.format("deleteInstance(%s): %s", endpoint, o));
            }
        }
    }

    static {
        listener.initialize();
    }

    public static class NonceException
    extends XWSSecurityException {
        public NonceException(String message) {
            super(message);
        }

        public NonceException(String message, Throwable cause) {
            super(message, cause);
        }

        public NonceException(Throwable cause) {
            super(cause);
        }
    }
}

